/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.sounds;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityBoundSoundLoop<E extends Entity>
extends AbstractTickableSoundInstance {
    public final E entity;

    public EntityBoundSoundLoop(SoundEvent soundEvent, SoundSource soundSource, E entity) {
        this(soundEvent, soundSource, entity, 1.0f, 1.0f, 0);
    }

    public EntityBoundSoundLoop(SoundEvent soundEvent, SoundSource soundSource, E entity, float volume, float pitch, int delay) {
        super(soundEvent, soundSource, SoundInstance.m_235150_());
        this.f_119573_ = volume;
        this.f_119574_ = pitch;
        this.entity = entity;
        this.f_119579_ = delay;
        this.f_119578_ = true;
        this.updatePosition();
    }

    public abstract boolean shouldStop();

    public boolean m_7767_() {
        return super.m_7767_();
    }

    protected void updatePosition() {
        Vect3d center = ForgeEntity.getCenterPosition(this.entity);
        this.f_119575_ = center.x;
        this.f_119576_ = center.y;
        this.f_119577_ = center.z;
    }

    public void m_7788_() {
        if (this.entity.m_213877_() || this.shouldStop()) {
            this.m_119609_();
        } else {
            this.updatePosition();
        }
    }
}

