/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.predicate.fullface;

import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;

public interface FullFacePredicate
extends BiPredicate<BlockState, Direction> {
    public static final FullFacePredicate TRUE = (state, dir) -> true;
    public static final FullFacePredicate FALSE = (state, dir) -> false;
    public static final FullFacePredicate Y_AXIS = (state, dir) -> Utils.isY(dir);
    public static final FullFacePredicate TOP = (state, dir) -> ((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue() ? dir == Direction.UP : dir == Direction.DOWN;
    public static final FullFacePredicate DIR = (state, dir) -> dir == state.m_61143_((Property)BlockStateProperties.f_61372_);
    public static final FullFacePredicate DIR_OPPOSITE = (state, dir) -> dir == ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
    public static final FullFacePredicate DIR_AXIS = (state, dir) -> dir.m_122434_() == ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
    public static final FullFacePredicate NOT_DIR = (state, dir) -> dir != state.m_61143_((Property)BlockStateProperties.f_61372_);
    public static final FullFacePredicate HOR_DIR = (state, dir) -> dir == state.m_61143_((Property)FramedProperties.FACING_HOR);
    public static final FullFacePredicate HOR_DIR_OPPOSITE = (state, dir) -> dir == ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_();
    public static final FullFacePredicate HOR_DIR_AXIS = (state, dir) -> dir.m_122434_() == ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122434_();
    public static final FullFacePredicate NOT_HOR_DIR = (state, side) -> side != state.m_61143_((Property)FramedProperties.FACING_HOR);
    public static final FullFacePredicate AXIS = (state, side) -> side.m_122434_() == state.m_61143_((Property)BlockStateProperties.f_61365_);
    public static final FullFacePredicate NOT_AXIS = (state, side) -> side.m_122434_() != state.m_61143_((Property)BlockStateProperties.f_61365_);

    @Override
    public boolean test(BlockState var1, Direction var2);

    default public FullFacePredicate and(BiPredicate<? super BlockState, ? super Direction> other) {
        Objects.requireNonNull(other);
        return (state, side) -> this.test(state, side) && other.test(state, side);
    }

    default public FullFacePredicate or(BiPredicate<? super BlockState, ? super Direction> other) {
        Objects.requireNonNull(other);
        return (state, side) -> this.test(state, side) || other.test(state, side);
    }
}

