/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.util.RecipeViewer;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.FramingSawMenu;
import xfacthd.framedblocks.common.menu.IFramingSawMenu;
import xfacthd.framedblocks.common.net.SelectFramingSawRecipePacket;
import xfacthd.framedblocks.common.util.RecipeUtils;

public class FramingSawScreen
extends AbstractContainerScreen<FramingSawMenu> {
    public static final String TOOLTIP_MATERIAL = Utils.translationKey("tooltip", "framing_saw.material");
    public static final Component TOOLTIP_LOOSE_ADDITIVE = Utils.translate("tooltip", "framing_saw.loose_additive");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_TAG = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_tag");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item_count");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_material_count");
    public static final String TOOLTIP_OUTPUT_COUNT = Utils.translationKey("tooltip", "framing_saw.output_count");
    public static final Component TOOLTIP_HAVE_ITEM_NONE = Utils.translate("tooltip", "framing_saw.have_item_none").m_130940_(ChatFormatting.GOLD);
    public static final String TOOLTIP_PRESS_TO_SHOW = Utils.translationKey("tooltip", "framing_saw.press_to_show");
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/framing_saw.png");
    public static final ResourceLocation WARNING_ICON = new ResourceLocation("forge", "textures/gui/experimental_warning.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 233;
    private static final int RECIPES_X = 48;
    private static final int RECIPES_Y = 18;
    private static final int RECIPE_ROWS = 6;
    private static final int RECIPE_COLS = 8;
    private static final int RECIPE_COUNT = 48;
    private static final int RECIPE_WIDTH = 18;
    private static final int RECIPE_HEIGHT = 18;
    private static final int SCROLL_BAR_X = 195;
    private static final int SCROLL_BAR_Y = 18;
    private static final int SCROLL_BTN_WIDTH = 12;
    private static final int SCROLL_BTN_HEIGHT = 15;
    private static final int SCROLL_BTN_TEX_X = 54;
    private static final int SCROLL_BAR_HEIGHT = 108;
    private static final int WARNING_X = 20;
    private static final int WARNING_Y = 46;
    private static final RecipeViewer RECIPE_VIEWER = RecipeViewer.get();
    private final FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
    private final ItemStack cubeStack = new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_CUBE.get());
    private int firstIndex = 0;
    private boolean scrolling = false;
    private float scrollOffset = 0.0f;

    public FramingSawScreen(FramingSawMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        --this.f_97729_;
        this.f_97730_ = 47;
        this.f_97731_ = 139;
        this.f_97726_ = 256;
        this.f_97727_ = 233;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(BACKGROUND, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int offset = (int)(93.0f * this.scrollOffset);
        int scrollU = 54 + (this.isScrollBarActive() ? 0 : 12);
        graphics.m_280218_(BACKGROUND, this.f_97735_ + 195, this.f_97736_ + 18 + offset, scrollU, this.f_97727_, 12, 15);
        ItemStack input = ((FramingSawMenu)this.f_97732_).getInputStack();
        if (!input.m_41619_() && this.cache.containsAdditive(input.m_41720_())) {
            graphics.m_280163_(WARNING_ICON, this.f_97735_ + 20, this.f_97736_ + 46, 8.0f, 8.0f, 24, 24, 32, 32);
        }
        int idx = ((FramingSawMenu)this.f_97732_).getSelectedRecipeIndex();
        if (((FramingSawMenu)this.f_97732_).hasRecipeChanged()) {
            this.tryScrollToRecipe(idx);
        }
        int recX = this.f_97735_ + 48;
        int recY = this.f_97736_ + 18;
        int lastIndex = this.firstIndex + 48;
        this.renderButtons(graphics, mouseX, mouseY, recX, recY, lastIndex);
        this.renderRecipes(graphics, recX, recY, lastIndex);
        List<FramingSawRecipe> recipes = this.cache.getRecipes();
        if (idx >= 0 && idx < recipes.size()) {
            FramingSawRecipe recipe = recipes.get(idx);
            if (input.m_41619_()) {
                ClientUtils.renderTransparentFakeItem(graphics, this.cubeStack, this.f_97735_ + 20, this.f_97736_ + 28);
            }
            List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                if (!((FramingSawMenu)this.f_97732_).getAdditiveStack(i).m_41619_()) continue;
                ItemStack[] items = additives.get(i).ingredient().m_43908_();
                int t = (int)(System.currentTimeMillis() / 1700L) % items.length;
                int y = this.f_97736_ + 64 + 18 * i;
                ClientUtils.renderTransparentFakeItem(graphics, items[t], this.f_97735_ + 20, y);
            }
        }
    }

    private void tryScrollToRecipe(int idx) {
        if (idx != -1 && (idx < this.firstIndex || idx >= this.firstIndex + 48)) {
            int row = idx / 8 - 2;
            int hidden = this.getHiddenRows();
            this.scrollOffset = (float)row / (float)hidden;
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(hidden);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((FramingSawMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.renderItemTooltip(graphics, mouseX, mouseY, this.f_97734_.m_7993_(), null);
            return;
        }
        ItemStack input = ((FramingSawMenu)this.f_97732_).getInputStack();
        if (!input.m_41619_() && this.m_6774_(20, 46, 16, 16, mouseX, mouseY) && this.cache.containsAdditive(input.m_41720_())) {
            graphics.m_280557_(this.f_96547_, TOOLTIP_LOOSE_ADDITIVE, mouseX, mouseY);
            return;
        }
        int x = this.f_97735_ + 48;
        int y = this.f_97736_ + 18;
        int last = this.firstIndex + 48;
        List<FramingSawMenu.RecipeHolder> recipes = ((FramingSawMenu)this.f_97732_).getRecipes();
        for (int idx = this.firstIndex; idx < last && idx < recipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int recX = x + relIdx % 8 * 18;
            int recY = y + relIdx / 8 * 18;
            if (mouseX < recX || mouseX >= recX + 18 || mouseY < recY || mouseY >= recY + 18) continue;
            FramingSawMenu.RecipeHolder recipe = recipes.get(idx);
            ItemStack result = recipe.getRecipe().getResult();
            this.renderItemTooltip(graphics, mouseX, mouseY, result, recipe);
        }
    }

    private void renderItemTooltip(GuiGraphics graphics, int mouseX, int mouseY, ItemStack stack, FramingSawMenu.RecipeHolder recipeHolder) {
        ArrayList<Component> components = new ArrayList<Component>(FramingSawScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)stack));
        Optional tooltip = stack.m_150921_();
        int material = this.cache.getMaterialValue(stack.m_41720_());
        if (material > 0) {
            components.add((Component)Component.m_237110_((String)TOOLTIP_MATERIAL, (Object[])new Object[]{material}));
        }
        if (recipeHolder != null) {
            this.appendRecipeFailure(components, recipeHolder);
        }
        graphics.renderTooltip(this.f_96547_, components, tooltip, stack, mouseX, mouseY);
    }

    private void appendRecipeFailure(List<Component> components, FramingSawMenu.RecipeHolder recipeHolder) {
        FramingSawScreen.appendRecipeFailure(components, this.cache, recipeHolder.getRecipe(), recipeHolder.getMatchResult(), (IFramingSawMenu)this.f_97732_);
    }

    public static List<Component> appendRecipeFailure(List<Component> components, FramingSawRecipeCache cache, FramingSawRecipe recipe, FramingSawRecipeMatchResult matchResult, IFramingSawMenu menu) {
        if (!matchResult.success()) {
            components.add(matchResult.translation());
            ItemStack input = menu.getInputStack();
            int listAdditives = -1;
            MutableComponent detail = switch (matchResult) {
                default -> throw new IncompatibleClassChangeError();
                case FramingSawRecipeMatchResult.MATERIAL_VALUE -> {
                    int matIn = input.m_41619_() ? 0 : cache.getMaterialValue(input.m_41720_()) * input.m_41613_();
                    int matReq = recipe.getMaterialAmount();
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(matIn)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Integer.toString(matReq)).m_130940_(ChatFormatting.GOLD)});
                }
                case FramingSawRecipeMatchResult.MATERIAL_LCM -> {
                    if (input.m_41619_()) {
                        yield Component.m_237119_();
                    }
                    FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(menu.getInputContainer(), true);
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(input.m_41613_())).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Integer.toString(calc.getInputCount())).m_130940_(ChatFormatting.GOLD)});
                }
                case FramingSawRecipeMatchResult.OUTPUT_SIZE -> {
                    if (input.m_41619_()) {
                        yield Component.m_237119_();
                    }
                    FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(menu.getInputContainer(), true);
                    int maxSize = recipe.getResult().m_41741_();
                    yield Component.m_237110_((String)TOOLTIP_OUTPUT_COUNT, (Object[])new Object[]{calc.getOutputCount(), maxSize});
                }
                case FramingSawRecipeMatchResult.MISSING_ADDITIVE_0, FramingSawRecipeMatchResult.MISSING_ADDITIVE_1, FramingSawRecipeMatchResult.MISSING_ADDITIVE_2 -> {
                    listAdditives = matchResult.additiveSlot();
                    Ingredient additive = recipe.getAdditives().get(matchResult.additiveSlot()).ingredient();
                    yield FramingSawScreen.makeHaveButNeedTooltip(TOOLTIP_HAVE_ITEM_NONE, additive);
                }
                case FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_0, FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_1, FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_2 -> {
                    Item itemIn = menu.getAdditiveStack(matchResult.additiveSlot()).m_41720_();
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM, (Object[])new Object[]{Component.m_237115_((String)itemIn.m_5524_()).m_130940_(ChatFormatting.GOLD), TOOLTIP_HAVE_ITEM_NONE});
                }
                case FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_0, FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_1, FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_2 -> {
                    listAdditives = matchResult.additiveSlot();
                    Item itemIn = menu.getAdditiveStack(matchResult.additiveSlot()).m_41720_();
                    Ingredient additive = recipe.getAdditives().get(matchResult.additiveSlot()).ingredient();
                    yield FramingSawScreen.makeHaveButNeedTooltip((Component)Component.m_237115_((String)itemIn.m_5524_()).m_130940_(ChatFormatting.GOLD), additive);
                }
                case FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_0, FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_1, FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_2 -> {
                    if (input.m_41619_()) {
                        yield Component.m_237119_();
                    }
                    FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(menu.getInputContainer(), true);
                    int cntIn = menu.getAdditiveStack(matchResult.additiveSlot()).m_41613_();
                    int cntReq = calc.getAdditiveCount(matchResult.additiveSlot());
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(cntIn)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Integer.toString(cntReq)).m_130940_(ChatFormatting.GOLD)});
                }
                case FramingSawRecipeMatchResult.SUCCESS -> throw new IllegalStateException("Unreachable");
            };
            components.add((Component)detail.m_130940_(ChatFormatting.RED));
            if (listAdditives > -1) {
                FramingSawScreen.appendAdditiveItemOptions(components, recipe, listAdditives);
            }
        }
        return components;
    }

    private static void appendAdditiveItemOptions(List<Component> components, FramingSawRecipe recipe, int additiveSlot) {
        Ingredient additive = recipe.getAdditives().get(additiveSlot).ingredient();
        if (additive.m_43908_().length <= 1) {
            return;
        }
        if (FramingSawScreen.m_96638_()) {
            for (ItemStack option : additive.m_43908_()) {
                components.add((Component)Component.m_237113_((String)"- ").m_7220_(option.m_41720_().m_41466_()).m_130940_(ChatFormatting.GOLD));
            }
        } else {
            Component keyName = InputConstants.m_84827_((int)340, (int)-1).m_84875_();
            components.add((Component)Component.m_237110_((String)TOOLTIP_PRESS_TO_SHOW, (Object[])new Object[]{Component.m_237113_((String)"").m_7220_(keyName).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.RED));
        }
    }

    private static MutableComponent makeHaveButNeedTooltip(Component present, Ingredient additive) {
        Ingredient.Value value;
        ItemStack[] options = additive.m_43908_();
        if (options.length > 1 && (value = RecipeUtils.getSingleIngredientValue(additive)) instanceof Ingredient.TagValue) {
            Ingredient.TagValue value2 = (Ingredient.TagValue)value;
            TagKey<Item> tag = RecipeUtils.getItemTagFromValue(value2);
            return Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_TAG, (Object[])new Object[]{present, Component.m_237113_((String)("#" + tag.f_203868_())).m_130940_(ChatFormatting.GOLD)});
        }
        return Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM, (Object[])new Object[]{present, Component.m_237115_((String)options[0].m_41720_().m_5524_()).m_130940_(ChatFormatting.GOLD)});
    }

    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int lastIdx) {
        List<FramingSawMenu.RecipeHolder> recipes = ((FramingSawMenu)this.f_97732_).getRecipes();
        for (int idx = this.firstIndex; idx < lastIdx && idx < recipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int recX = x + relIdx % 8 * 18;
            int recY = y + relIdx / 8 * 18;
            int u = 0;
            boolean hovered = false;
            if (idx == ((FramingSawMenu)this.f_97732_).getSelectedRecipeIndex()) {
                u += 18;
            } else if (mouseX >= recX && mouseY >= recY && mouseX < recX + 18 && mouseY < recY + 18) {
                u += 36;
                hovered = true;
            }
            if (!hovered && !recipes.get(idx).getMatchResult().success()) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            graphics.m_280218_(BACKGROUND, recX, recY, u, this.f_97727_, 18, 18);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int pLeft, int pTop, int lastIndex) {
        List<FramingSawMenu.RecipeHolder> recipes = ((FramingSawMenu)this.f_97732_).getRecipes();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int idx = this.firstIndex; idx < lastIndex && idx < recipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int x = pLeft + relIdx % 8 * 18 + 1;
            int y = pTop + relIdx / 8 * 18 + 1;
            ItemStack stack = recipes.get(idx).getRecipe().getResult();
            graphics.m_280256_(stack, x, y, x * y * this.f_97726_);
            graphics.m_280370_(this.f_96547_, stack, x, y);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int x = this.f_97735_ + 48;
        int y = this.f_97736_ + 18;
        int lastIdx = this.firstIndex + 48;
        for (int idx = this.firstIndex; idx < lastIdx; ++idx) {
            int relIdx = idx - this.firstIndex;
            double recRelX = mouseX - (double)(x + relIdx % 8 * 18);
            double recRelY = mouseY - (double)(y + relIdx / 8 * 18);
            if (recRelX < 0.0 || recRelY < 0.0 || recRelX > 18.0 || recRelY > 18.0 || !((FramingSawMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, idx)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            FramedBlocks.CHANNEL.sendToServer((Object)new SelectFramingSawRecipePacket(((FramingSawMenu)this.f_97732_).f_38840_, idx));
            return true;
        }
        if (this.isScrollBarActive()) {
            x = this.f_97735_ + 195;
            y = this.f_97736_ + 18;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 108)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            float topY = this.f_97736_ + 18;
            float botY = topY + 108.0f;
            float freeScrollHeight = botY - topY - 15.0f;
            this.scrollOffset = ((float)mouseY - topY - 7.5f) / freeScrollHeight;
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(this.getHiddenRows());
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int hiddenRows = this.getHiddenRows();
            float offset = (float)delta / (float)hiddenRows;
            this.scrollOffset = Mth.m_14036_((float)(this.scrollOffset - offset), (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(hiddenRows);
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        RecipeViewer.LookupTarget target;
        if (RECIPE_VIEWER != null && (target = RECIPE_VIEWER.isShowRecipePressed(keyCode, scanCode)) != null) {
            double mouseY;
            Window window = Objects.requireNonNull(this.f_96541_).m_91268_();
            MouseHandler mouseHandler = this.f_96541_.f_91067_;
            double mouseX = mouseHandler.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            FramingSawRecipe recipe = this.getRecipeAt(mouseX, mouseY = mouseHandler.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_());
            if (recipe != null && RECIPE_VIEWER.handleShowRecipeRequest(recipe.getResult(), target)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public FramingSawRecipe getRecipeAt(double mouseX, double mouseY) {
        double x = this.f_97735_ + 48;
        double y = this.f_97736_ + 18;
        if (mouseX >= x && mouseX <= x + 144.0 && mouseY >= y && mouseY <= y + 108.0) {
            int col = (int)((mouseX - x) / 18.0);
            int row = (int)((mouseY - y) / 18.0);
            int idx = row * 8 + col + this.firstIndex;
            List<FramingSawRecipe> recipes = this.cache.getRecipes();
            if (idx > 0 && idx < recipes.size()) {
                return this.cache.getRecipes().get(idx);
            }
        }
        return null;
    }

    private boolean isScrollBarActive() {
        return ((FramingSawMenu)this.f_97732_).getRecipes().size() > 48;
    }

    private int getHiddenRows() {
        return (((FramingSawMenu)this.f_97732_).getRecipes().size() + 8 - 1) / 8 - 6;
    }

    private int calculateFirstIndex(int hiddenRows) {
        return (int)((double)(this.scrollOffset * (float)hiddenRows) + 0.5) * 8;
    }
}

