/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record FloatArrayLoadable(Loadable<Float> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<float[]>
{
    @Override
    public int getLength(float[] array) {
        return array.length;
    }

    @Override
    public float[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new float[]{this.base.convert(element, key, context).floatValue()};
    }

    @Override
    public float[] convertArray(JsonArray array, String key, TypedMap context) {
        float[] result = new float[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context).floatValue();
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(float[] object) {
        return this.base.serialize(Float.valueOf(object[0]));
    }

    @Override
    public void serializeAll(JsonArray array, float[] object) {
        for (float element : object) {
            array.add(this.base.serialize(Float.valueOf(element)));
        }
    }

    @Override
    public float[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        float[] array = new float[max];
        for (int i = 0; i < max; ++i) {
            array[i] = ((Float)this.base.decode(buffer, context)).floatValue();
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, float[] array) {
        buffer.m_130130_(array.length);
        for (float element : array) {
            this.base.encode(buffer, Float.valueOf(element));
        }
    }

    @Override
    public <P> LoadableField<float[], P> defaultField(String key, float[] defaultValue, boolean serializeDefault, Function<P, float[]> getter) {
        return new DefaultingField<float[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<float[], P> emptyField(String key, boolean serializeEmpty, Function<P, float[]> getter) {
        return this.defaultField(key, new float[0], serializeEmpty, getter);
    }
}

