/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.data.MantleCodecs;
import slimeknights.mantle.loot.AbstractLootModifierBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;

public class ReplaceItemLootModifier
extends LootModifier {
    public static final Codec<ReplaceItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> ReplaceItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)MantleCodecs.INGREDIENT.fieldOf("original").forGetter(m -> m.original), (App)ItemOutput.REQUIRED_STACK_CODEC.fieldOf("replacement").forGetter(m -> m.replacement), (App)MantleCodecs.LOOT_FUNCTIONS.fieldOf("functions").forGetter(m -> m.functions))).apply((Applicative)inst, ReplaceItemLootModifier::new));
    private final Ingredient original;
    private final ItemOutput replacement;
    private final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;

    protected ReplaceItemLootModifier(LootItemCondition[] conditionsIn, Ingredient original, ItemOutput replacement, LootItemFunction[] functions) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
        this.functions = functions;
        this.combinedFunctions = LootItemFunctions.m_80770_((BiFunction[])functions);
    }

    public static Builder builder(Ingredient original, ItemOutput replacement) {
        return new Builder(original, replacement);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectListIterator iterator = generatedLoot.listIterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (!this.original.test(stack)) continue;
            ItemStack replacement = this.replacement.get();
            iterator.set(this.combinedFunctions.apply(ItemHandlerHelper.copyStackWithSize((ItemStack)replacement, (int)(replacement.m_41613_() * stack.m_41613_())), context));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final Ingredient input;
        private final ItemOutput replacement;
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();

        public Builder addFunction(LootItemFunction function) {
            this.functions.add(function);
            return this;
        }

        public ReplaceItemLootModifier build() {
            return new ReplaceItemLootModifier(this.getConditions(), this.input, this.replacement, this.functions.toArray(new LootItemFunction[0]));
        }

        private Builder(Ingredient input, ItemOutput replacement) {
            this.input = input;
            this.replacement = replacement;
        }
    }
}

