/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.ActivatingIRecipe;
import mekanism.common.recipe.impl.CentrifugingIRecipe;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.GasToGas")
public abstract class GasToGasRecipeManager
extends MekanismRecipeManager<GasToGasRecipe> {
    protected GasToGasRecipeManager(IMekanismRecipeTypeProvider<GasToGasRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ChemicalStackIngredient.GasStackIngredient input, ICrTChemicalStack.ICrTGasStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, output));
    }

    public final GasToGasRecipe makeRecipe(ResourceLocation id, ChemicalStackIngredient.GasStackIngredient input, ICrTChemicalStack.ICrTGasStack output) {
        return this.makeRecipe(id, input, this.getAndValidateNotEmpty(output));
    }

    protected abstract GasToGasRecipe makeRecipe(ResourceLocation var1, ChemicalStackIngredient.GasStackIngredient var2, GasStack var3);

    @Override
    protected String describeOutputs(GasToGasRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.GasToGas.Centrifuging")
    public static class IsotopicCentrifugeRecipeManager
    extends GasToGasRecipeManager {
        public static final IsotopicCentrifugeRecipeManager INSTANCE = new IsotopicCentrifugeRecipeManager();

        private IsotopicCentrifugeRecipeManager() {
            super((IMekanismRecipeTypeProvider<GasToGasRecipe, ?>)MekanismRecipeType.CENTRIFUGING);
        }

        @Override
        protected GasToGasRecipe makeRecipe(ResourceLocation id, ChemicalStackIngredient.GasStackIngredient ingredient, GasStack output) {
            return new CentrifugingIRecipe(id, ingredient, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.GasToGas.Activating")
    public static class SolarNeutronActivatorRecipeManager
    extends GasToGasRecipeManager {
        public static final SolarNeutronActivatorRecipeManager INSTANCE = new SolarNeutronActivatorRecipeManager();

        private SolarNeutronActivatorRecipeManager() {
            super((IMekanismRecipeTypeProvider<GasToGasRecipe, ?>)MekanismRecipeType.ACTIVATING);
        }

        @Override
        protected GasToGasRecipe makeRecipe(ResourceLocation id, ChemicalStackIngredient.GasStackIngredient ingredient, GasStack output) {
            return new ActivatingIRecipe(id, ingredient, output);
        }
    }
}

