/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileComponentFrequency
implements ITileComponent {
    private final TileEntityMekanism tile;
    private final Map<FrequencyType<?>, FrequencyData> supportedFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> publicCache = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> privateCache = new LinkedHashMap();
    private boolean needsSave;
    private boolean needsNotify;

    public TileComponentFrequency(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    public boolean hasCustomFrequencies() {
        if (this.supportedFrequencies.containsKey(FrequencyType.SECURITY)) {
            return this.supportedFrequencies.size() > 1;
        }
        return !this.supportedFrequencies.isEmpty();
    }

    public void tickServer() {
        for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.supportedFrequencies.entrySet()) {
            this.updateFrequency(entry.getKey(), entry.getValue());
        }
        if (this.needsNotify) {
            this.tile.invalidateCachedCapabilities();
            WorldUtils.notifyLoadedNeighborsOfTileChange(this.tile.m_58904_(), this.tile.m_58899_());
            this.needsNotify = false;
        }
        if (this.needsSave) {
            this.tile.m_6596_();
            this.needsSave = false;
        }
    }

    public void track(FrequencyType<?> type, boolean needsSync, boolean needsListCache, boolean notifyNeighbors) {
        this.supportedFrequencies.put(type, new FrequencyData(needsSync, needsListCache, notifyNeighbors));
    }

    @Nullable
    public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        FrequencyData frequencyData = this.supportedFrequencies.get(type);
        if (frequencyData == null) {
            return null;
        }
        return (FREQ)frequencyData.selectedFrequency;
    }

    public <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type) {
        this.unsetFrequency(type, this.supportedFrequencies.get(type));
    }

    private <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        if (frequencyData != null && frequencyData.selectedFrequency != null) {
            this.deactivate(type, frequencyData);
            frequencyData.clearFrequency();
            this.setNeedsNotify(frequencyData);
        }
    }

    public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.getCache(this.publicCache, type);
    }

    public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.getCache(this.privateCache, type);
    }

    private <FREQ extends Frequency> List<FREQ> getCache(Map<FrequencyType<?>, List<? extends Frequency>> cache, FrequencyType<FREQ> type) {
        return cache.computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyData frequencyData;
        if (player != null && (frequencyData = this.supportedFrequencies.get(type)) != null) {
            this.setFrequencyFromData(type, data, player, frequencyData);
        }
    }

    private <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, @NotNull UUID player, FrequencyData frequencyData) {
        Frequency oldFrequency = frequencyData.selectedFrequency;
        FrequencyManager<FREQ> manager = type.getManager(data, player);
        FREQ freq = manager.getOrCreateFrequency(data, player);
        if (!((Frequency)freq).equals(oldFrequency)) {
            manager.deactivate(oldFrequency, this.tile);
            ((Frequency)freq).update(this.tile);
            frequencyData.setFrequency((Frequency)freq);
            this.setNeedsNotify(frequencyData);
        }
    }

    public void removeFrequencyFromData(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyManager<?> manager = type.getManager(data, player);
        if (manager != null && manager.remove(data.key(), player)) {
            this.setNeedsNotify(this.supportedFrequencies.get(type));
        }
    }

    private <FREQ extends Frequency> void updateFrequency(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        if (frequencyData.selectedFrequency != null) {
            if (frequencyData.selectedFrequency.isValid()) {
                if (frequencyData.selectedFrequency.isRemoved()) {
                    FrequencyManager<Frequency> manager = type.getFrequencyManager(frequencyData.selectedFrequency);
                    if (manager != null) {
                        manager.deactivate(frequencyData.selectedFrequency, this.tile);
                    }
                    frequencyData.clearFrequency();
                    this.setNeedsNotify(frequencyData);
                }
            } else {
                Frequency frequency = frequencyData.selectedFrequency;
                FrequencyManager<Frequency> manager = type.getFrequencyManager(frequency);
                if (manager == null) {
                    frequencyData.clearFrequency();
                } else {
                    frequencyData.setFrequency(manager.validateAndUpdate(this.tile, frequency));
                }
                this.setNeedsNotify(frequencyData);
            }
        }
    }

    private void setNeedsNotify(FrequencyData data) {
        if (data.notifyNeighbors) {
            this.needsNotify = true;
        }
        this.needsSave = true;
    }

    private <FREQ extends Frequency> void deactivate(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        FrequencyManager<Frequency> manager;
        if (frequencyData.selectedFrequency != null && (manager = type.getFrequencyManager(frequencyData.selectedFrequency)) != null) {
            manager.deactivate(frequencyData.selectedFrequency, this.tile);
        }
    }

    @Override
    public void read(CompoundTag nbtTags) {
        if (nbtTags.m_128425_("componentFrequency", 10)) {
            CompoundTag frequencyNBT = nbtTags.m_128469_("componentFrequency");
            for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.supportedFrequencies.entrySet()) {
                FrequencyType<?> type = entry.getKey();
                if (!frequencyNBT.m_128425_(type.getName(), 10)) continue;
                Object frequency = type.create(frequencyNBT.m_128469_(type.getName()));
                ((Frequency)frequency).setValid(false);
                entry.getValue().setFrequency((Frequency)frequency);
            }
        }
    }

    @Override
    public void write(CompoundTag nbtTags) {
        CompoundTag frequencyNBT = new CompoundTag();
        for (FrequencyData frequencyData : this.supportedFrequencies.values()) {
            Frequency frequency = frequencyData.selectedFrequency;
            if (frequency == null) continue;
            CompoundTag frequencyTag = new CompoundTag();
            frequency.writeComponentData(frequencyTag);
            frequencyNBT.m_128365_(frequency.getType().getName(), (Tag)frequencyTag);
        }
        nbtTags.m_128365_("componentFrequency", (Tag)frequencyNBT);
    }

    public void readConfiguredFrequencies(Player player, CompoundTag data) {
        if (this.hasCustomFrequencies() && data.m_128425_("componentFrequency", 10)) {
            CompoundTag frequencyNBT = data.m_128469_("componentFrequency");
            for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.supportedFrequencies.entrySet()) {
                Frequency.FrequencyIdentity identity;
                CompoundTag frequencyData;
                FrequencyType<?> type = entry.getKey();
                if (type == FrequencyType.SECURITY) continue;
                if (frequencyNBT.m_128425_(type.getName(), 10) && (frequencyData = frequencyNBT.m_128469_(type.getName())).m_128403_("owner") && (identity = Frequency.FrequencyIdentity.load(type, frequencyData)) != null) {
                    UUID owner = frequencyData.m_128342_("owner");
                    if (!identity.isPublic() && !owner.equals(player.m_20148_())) continue;
                    this.setFrequencyFromData(type, identity, owner, entry.getValue());
                    continue;
                }
                this.unsetFrequency(type, entry.getValue());
            }
        }
    }

    public void writeConfiguredFrequencies(CompoundTag data) {
        CompoundTag frequencyNBT = new CompoundTag();
        for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.supportedFrequencies.entrySet()) {
            Frequency frequency = entry.getValue().selectedFrequency;
            if (frequency == null || entry.getKey() == FrequencyType.SECURITY) continue;
            frequencyNBT.m_128365_(entry.getKey().getName(), (Tag)frequency.serializeIdentityWithOwner());
        }
        if (!frequencyNBT.m_128456_()) {
            data.m_128365_("componentFrequency", (Tag)frequencyNBT);
        }
    }

    @Override
    public void invalidate() {
        if (!this.tile.isRemote()) {
            this.supportedFrequencies.forEach(this::deactivate);
        }
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.supportedFrequencies.entrySet()) {
            FrequencyData data = entry.getValue();
            if (data.needsContainerSync) {
                container.track(SyncableFrequency.create(() -> data.selectedFrequency, data::setFrequency));
            }
            if (!data.needsListCache) continue;
            this.track(container, entry.getKey());
        }
    }

    private <FREQ extends Frequency> void track(MekanismContainer container, FrequencyType<FREQ> type) {
        if (container.isRemote()) {
            container.track(SyncableFrequencyList.create(() -> this.getPublicCache(type), value -> this.publicCache.put(type, (List<Frequency>)value)));
            container.track(SyncableFrequencyList.create(() -> this.getPrivateCache(type), value -> this.privateCache.put(type, (List<Frequency>)value)));
        } else {
            container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPublicManager().getFrequencies(), value -> this.publicCache.put(type, (List<Frequency>)value)));
            container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPrivateManager(container.getPlayerUUID()).getFrequencies(), value -> this.privateCache.put(type, (List<Frequency>)value)));
        }
    }

    private static final class FrequencyData {
        private final boolean needsContainerSync;
        private final boolean needsListCache;
        private final boolean notifyNeighbors;
        @Nullable
        private Frequency selectedFrequency;

        private FrequencyData(boolean needsContainerSync, boolean needsListCache, boolean notifyNeighbors) {
            this.needsContainerSync = needsContainerSync;
            this.needsListCache = needsListCache;
            this.notifyNeighbors = notifyNeighbors;
        }

        public void setFrequency(@Nullable Frequency frequency) {
            this.selectedFrequency = frequency;
        }

        public void clearFrequency() {
            this.setFrequency(null);
        }
    }
}

