/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items.modules;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.WeaponsLang;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class DrawSpeedUnit
implements ICustomModule<DrawSpeedUnit> {
    public static final ResourceLocation DRAWSPEED = MekaWeapons.rl("drawspeed");
    private static final Int2ObjectMap<Lazy<NestedRadialMode>> RADIAL_DATAS = (Int2ObjectMap)Util.m_137537_(() -> {
        int types = DrawSpeed.values().length - 1;
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(types);
        for (int type = 1; type <= types; ++type) {
            int accessibleValues = type + 1;
            map.put(type, (Object)Lazy.of(() -> new NestedRadialMode(IRadialDataHelper.INSTANCE.dataForTruncated(DRAWSPEED, accessibleValues, (Enum)DrawSpeed.LOW), (ILangEntry)WeaponsLang.RADIAL_DRAWSPEED_MODE, DrawSpeed.LOW.icon(), EnumColor.YELLOW)));
        }
        return map;
    });
    private IModuleConfigItem<DrawSpeed> drawSpeed;

    public void init(IModule<DrawSpeedUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.drawSpeed = configItemCreator.createConfigItem("drawspeed", (ILangEntry)WeaponsLang.RADIAL_DRAWSPEED_MODE, (ModuleConfigData)new ModuleEnumData((Enum)DrawSpeed.LOW, module.getInstalledCount() + 1));
    }

    @NotNull
    private NestedRadialMode getNestedData(IModule<DrawSpeedUnit> module) {
        return (NestedRadialMode)((Lazy)RADIAL_DATAS.get(module.getInstalledCount())).get();
    }

    @NotNull
    private RadialData<?> getRadialData(IModule<DrawSpeedUnit> module) {
        return this.getNestedData(module).nestedData();
    }

    public void addRadialModes(IModule<DrawSpeedUnit> module, ItemStack stack, Consumer<NestedRadialMode> adder) {
        adder.accept(this.getNestedData(module));
    }

    @Nullable
    public <MODE extends IRadialMode> MODE getMode(IModule<DrawSpeedUnit> module, ItemStack stack, RadialData<MODE> radialData) {
        return (MODE)(radialData == this.getRadialData(module) ? (IRadialMode)this.drawSpeed.get() : null);
    }

    public <MODE extends IRadialMode> boolean setMode(IModule<DrawSpeedUnit> module, Player player, ItemStack stack, RadialData<MODE> radialData, MODE mode) {
        if (radialData == this.getRadialData(module)) {
            DrawSpeed newMode = (DrawSpeed)mode;
            if (this.drawSpeed.get() != newMode) {
                this.drawSpeed.set((Object)newMode);
                return true;
            }
        }
        return false;
    }

    public void changeMode(IModule<DrawSpeedUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        DrawSpeed newMode;
        DrawSpeed speed = (DrawSpeed)((Object)this.drawSpeed.get());
        if (speed != (newMode = (DrawSpeed)speed.adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 1))) {
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)MekanismLang.MODULE_EFFICIENCY.translate(new Object[0]), (IHasTextComponent)newMode);
            }
            this.drawSpeed.set((Object)newMode);
        }
    }

    public void addHUDStrings(IModule<DrawSpeedUnit> module, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled()) {
            hudStringAdder.accept((Component)WeaponsLang.DRAWSPEED.translateColored(EnumColor.DARK_GRAY, new Object[]{EnumColor.INDIGO, ((DrawSpeed)((Object)this.drawSpeed.get())).sliceName()}));
        }
    }

    public int getDrawSpeed() {
        return ((DrawSpeed)((Object)this.drawSpeed.get())).ordinal();
    }

    @NothingNullByDefault
    public static enum DrawSpeed implements IIncrementalEnum<DrawSpeed>,
    IHasTextComponent,
    IRadialMode,
    StringRepresentable
    {
        OFF(WeaponsLang.RADIAL_TOGGLE_OFF, EnumColor.WHITE, "off"),
        LOW(WeaponsLang.RADIAL_ATTACK_DAMAGE_LOW, EnumColor.PINK, "damage_low"),
        MED(WeaponsLang.RADIAL_ATTACK_DAMAGE_MEDIUM, EnumColor.BRIGHT_GREEN, "damage_medium"),
        HIGH(WeaponsLang.RADIAL_ATTACK_DAMAGE_HIGH, EnumColor.YELLOW, "damage_high");

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final Component label;
        private final ResourceLocation icon;
        private final Component sliceNamePreCalc;
        public static final IntFunction<DrawSpeed> BY_ID;

        private DrawSpeed(ILangEntry langEntry, EnumColor color, String texture) {
            this.icon = MekaWeapons.getResource(MekanismUtils.ResourceType.GUI_RADIAL, texture + ".png");
            this.label = TextComponentUtil.getString((String)Integer.toString(this.ordinal()));
            this.sliceNamePreCalc = langEntry.translateColored(color, new Object[0]);
        }

        public Component getTextComponent() {
            return this.label;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public Component sliceName() {
            return this.sliceNamePreCalc;
        }

        public ResourceLocation icon() {
            return this.icon;
        }

        public DrawSpeed byIndex(int index) {
            return BY_ID.apply(index);
        }

        static {
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])DrawSpeed.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        }
    }
}

