/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.common.tile.TileTeleporter;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.common.item.ItemVoltaic;
import voltaic.prefab.utilities.NBTUtils;

public class ItemFrequencyCard
extends ItemVoltaic {
    public ItemFrequencyCard(Item.Properties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties.m_41487_(1), creativeTab);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return super.onItemUseFirst(stack, context);
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof TileTeleporter) {
            TileTeleporter teleporter = (TileTeleporter)blockEntity;
            CompoundTag nbt = stack.m_41784_();
            if (nbt.m_128441_("dimension")) {
                BlockPos pos = ItemFrequencyCard.readBlockPos(stack);
                ResourceKey<Level> world = ItemFrequencyCard.readDimension(stack);
                teleporter.destination.setValue((Object)pos);
                teleporter.dimension.setValue(world);
                MutableComponent worldKey = ElectroTextUtils.dimensionExists(world) ? ElectroTextUtils.dimension(world, (Object[])new Object[0]) : Component.m_237113_((String)world.m_135782_().m_135815_());
                context.m_43723_().m_213846_((Component)NuclearTextUtils.tooltip("frequencycard.linked", worldKey.m_130946_(" " + pos.m_123344_())));
            } else {
                ItemFrequencyCard.writeBlockPos(stack, teleporter.m_58899_());
                ItemFrequencyCard.writeDimension(stack, (ResourceKey<Level>)teleporter.m_58904_().m_46472_());
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            BlockPos pos = ItemFrequencyCard.readBlockPos(stack);
            ResourceKey<Level> world = ItemFrequencyCard.readDimension(stack);
            MutableComponent worldKey = ElectroTextUtils.dimensionExists(world) ? ElectroTextUtils.dimension(world, (Object[])new Object[0]) : Component.m_237113_((String)world.m_135782_().m_135815_());
            tooltip.add((Component)NuclearTextUtils.tooltip("frequencycard.linked", worldKey.m_130946_(" " + pos.m_123344_())));
        } else {
            tooltip.add((Component)NuclearTextUtils.tooltip("frequencycard.notag", new Object[0]));
        }
    }

    public static void writeBlockPos(ItemStack item, BlockPos pos) {
        item.m_41784_().m_128365_("loc", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static BlockPos readBlockPos(ItemStack item) {
        return NbtUtils.m_129239_((CompoundTag)item.m_41784_().m_128469_("loc"));
    }

    public static void writeDimension(ItemStack stack, ResourceKey<Level> dim) {
        stack.m_41784_().m_128365_("dimension", (Tag)NBTUtils.writeDimensionToTag(dim));
    }

    public static ResourceKey<Level> readDimension(ItemStack stack) {
        return NBTUtils.readDimensionFromTag((CompoundTag)stack.m_41784_().m_128469_("dimension"));
    }
}

