/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lehjr.numina.client.gui.frame.IGuiFrame;
import lehjr.numina.client.gui.geometry.IRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ContainerlessGui
extends Screen
implements IRect {
    public int imageWidth = 176;
    public int imageHeight = 166;
    public int leftPos;
    public int topPos;
    protected List<IGuiFrame> frames = new ArrayList<IGuiFrame>();
    protected IRect belowMe;
    protected IRect aboveMe;
    protected IRect leftOfMe;
    protected IRect rightOfMe;

    protected ContainerlessGui(Component titleIn) {
        super(titleIn);
    }

    public ContainerlessGui(Component titleIn, int guiWidth, int guiHeight) {
        this(titleIn);
        this.imageWidth = guiWidth;
        this.imageHeight = guiHeight;
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void addFrame(IGuiFrame frame) {
        this.frames.add(frame);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float frameTime) {
        this.m_280273_(gfx);
        this.update(mouseX, mouseY);
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        this.renderFrames(gfx, mouseX, mouseY, frameTime);
        gfx.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        super.m_88315_(gfx, mouseX, mouseY, frameTime);
        gfx.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        this.renderLabels(gfx, mouseX, mouseY);
        gfx.m_280168_().m_85849_();
        this.renderTooltip(gfx, mouseX, mouseY);
    }

    public void update(double x, double y) {
        for (IGuiFrame frame : this.frames) {
            frame.update(x, y);
        }
    }

    public void renderFrames(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        for (IGuiFrame frame : this.frames) {
            frame.m_88315_(gfx, mouseX, mouseY, partialTicks);
        }
    }

    public void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        this.renderFrameLabels(gfx, mouseX, mouseY);
    }

    public void renderFrameLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        this.frames.forEach(frame -> frame.renderLabels(gfx, mouseX, mouseY));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double dWheel) {
        for (IGuiFrame frame : this.frames) {
            if (!frame.mouseScrolled(mouseX, mouseY, dWheel)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6375_(double x, double y, int button) {
        for (IGuiFrame frame : this.frames) {
            frame.mouseClicked(x, y, button);
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int which) {
        for (IGuiFrame frame : this.frames) {
            if (!frame.mouseReleased(mouseX, mouseY, which)) continue;
            return true;
        }
        return false;
    }

    public void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        List<Component> tooltip = this.getToolTip(mouseX, mouseY);
        if (tooltip != null) {
            this.m_257959_(tooltip.stream().map(Component::m_7532_).collect(Collectors.toList()));
        }
    }

    public List<Component> getToolTip(int x, int y) {
        for (IGuiFrame frame : this.frames) {
            List<Component> hitTip = frame.getToolTip(x, y);
            if (hitTip == null) continue;
            return hitTip;
        }
        return null;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    @Override
    public MusePoint2D center() {
        return new MusePoint2D(this.getLeftPos(), this.getTopPos()).plus((double)this.getXSize() * 0.5, (double)this.getYSize() * 0.5);
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public int getXSize() {
        return this.imageWidth;
    }

    public void setXSize(int xSize) {
        this.imageWidth = xSize;
        this.leftPos = (this.f_96543_ - this.getXSize()) / 2;
    }

    public int getYSize() {
        return this.imageHeight;
    }

    public void setYSize(int ySize) {
        this.imageHeight = ySize;
        this.topPos = (this.f_96544_ - this.getYSize()) / 2;
    }

    public Minecraft getMinecraft() {
        this.f_96541_ = Minecraft.m_91087_();
        return this.f_96541_;
    }

    public int absX(double relx) {
        int absx = (int)((relx + 1.0) * (double)this.getImageWidth() / 2.0);
        int xpadding = (this.f_96543_ - this.getImageWidth()) / 2;
        return absx + xpadding;
    }

    public int relX(double absx) {
        int padding = (this.f_96543_ - this.getImageWidth()) / 2;
        return (int)((absx - (double)padding) * 2.0 / (double)this.getImageWidth() - 1.0);
    }

    public int absY(double rely) {
        int absy = (int)((rely + 1.0) * (double)this.imageHeight / 2.0);
        int ypadding = (this.f_96544_ - this.imageHeight) / 2;
        return absy + ypadding;
    }

    public int relY(float absy) {
        int padding = (this.f_96544_ - this.getYSize()) / 2;
        return (int)((absy - (float)padding) * 2.0f / (float)this.getYSize() - 1.0f);
    }

    @Override
    public double left() {
        return this.leftPos;
    }

    @Override
    public IRect setLeft(double value) {
        this.leftPos = (int)value;
        return this;
    }

    @Override
    public double top() {
        return this.topPos;
    }

    @Override
    public IRect setTop(double value) {
        this.topPos = (int)value;
        return this;
    }

    @Override
    public double right() {
        return this.left() + (double)this.imageWidth;
    }

    @Override
    public IRect setRight(double value) {
        return this.setLeft(value - (double)this.imageWidth);
    }

    @Override
    public double bottom() {
        return this.top() + (double)this.imageHeight;
    }

    @Override
    public IRect setBottom(double value) {
        return this.setTop(value - (double)this.imageHeight);
    }

    @Override
    public double width() {
        return this.imageWidth;
    }

    @Override
    public IRect setWidth(double value) {
        this.imageWidth = (int)value;
        return this;
    }

    @Override
    public double height() {
        return this.imageHeight;
    }

    @Override
    public IRect setHeight(double value) {
        this.imageHeight = (int)value;
        return this;
    }

    @Override
    public void setPosition(MusePoint2D positionIn) {
        IRect.super.setPosition(positionIn);
    }

    @Override
    public MusePoint2D getUL() {
        return new MusePoint2D(this.left(), this.top());
    }

    @Override
    public IRect setUL(MusePoint2D ul) {
        this.setLeft(ul.x());
        this.setTop(ul.y());
        return this;
    }

    @Override
    public MusePoint2D getWH() {
        return new MusePoint2D(this.imageWidth, this.imageHeight);
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        this.setWidth(wh.x());
        this.setHeight(wh.y());
        return this;
    }

    @Override
    public IRect setAbove(IRect belowMe) {
        this.belowMe = belowMe;
        return this;
    }

    @Override
    public IRect setLeftOf(IRect rightOfMe) {
        this.rightOfMe = rightOfMe;
        return this;
    }

    @Override
    public IRect setBelow(IRect aboveMe) {
        this.aboveMe = aboveMe;
        return this;
    }

    @Override
    public IRect setRightOf(IRect leftOfMe) {
        this.leftOfMe = leftOfMe;
        return this;
    }
}

