/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.client.gui.geometry.IRect;
import lehjr.numina.client.gui.geometry.IRectWrapper;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import net.minecraft.client.gui.GuiGraphics;

public abstract class Clickable<T extends IRect>
implements IClickable,
IRectWrapper {
    IClickable.IPressable onPressed;
    IClickable.IReleasable onReleased;
    boolean isEnabled = true;
    boolean isVisible = true;
    float blitOffset = 0.0f;
    T rect;

    public Clickable(T rect) {
        this.rect = rect;
    }

    public Clickable(double left, double top, double right, double bottom) {
        this.rect = new Rect(left, top, right, bottom);
    }

    public Clickable(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this.rect = new Rect(left, top, right, bottom, growFromMiddle);
    }

    public Clickable(MusePoint2D ul, MusePoint2D br) {
        this.rect = new Rect(ul, br);
    }

    public Clickable(MusePoint2D ul, MusePoint2D br, boolean growFromMiddle) {
        this.rect = new Rect(ul, br, growFromMiddle);
    }

    @Override
    public T getRect() {
        return this.rect;
    }

    public void setRect(IRect rect) {
        this.rect = rect;
    }

    @Override
    public float getZLevel() {
        return this.blitOffset;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        this.blitOffset = zLevel;
        return this;
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (this.rect instanceof IDrawableRect) {
            ((IDrawableRect)this.rect).m_88315_(gfx, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void enable() {
        this.isEnabled = true;
    }

    @Override
    public void disable() {
        this.isEnabled = false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void hide() {
        this.isVisible = false;
    }

    @Override
    public void show() {
        this.isVisible = true;
    }

    @Override
    public void enableAndShow() {
        this.enable();
        this.show();
    }

    @Override
    public void disableAndHide() {
        this.disable();
        this.hide();
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }
}

