/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.frame;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import lehjr.numina.client.gui.frame.AbstractGuiFrame;
import lehjr.numina.client.gui.frame.IGuiFrame;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityRenderFrame
extends AbstractGuiFrame
implements IGuiFrame {
    boolean isVisible = true;
    boolean isEnabled = true;
    boolean allowDrag = false;
    boolean allowZoom = false;
    private double oldMouseX = 20.0;
    private double oldMouseY = 20.0;
    double anchorx = 0.0;
    double anchory = 0.0;
    int dragging = -1;
    double rotx = 0.0;
    double roty = 0.0;
    double offsetx = 0.0;
    double offsety = -2.5;
    float zoom = 30.0f;
    double mouseX = 0.0;
    double mouseY = 0.0;
    double guiLeft = 0.0;
    double guiTop = 0.0;
    LivingEntity livingEntity;

    public EntityRenderFrame(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public EntityRenderFrame(double left, double top, double right, double bottom, boolean growFromMiddle) {
        super(new Rect(left, top, right, bottom, growFromMiddle));
    }

    public void setLivingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.dragging = button;
            this.anchorx = mouseX;
            this.anchory = mouseY;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.dragging = -1;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.containsPoint(mouseX, mouseY) && this.allowZoom) {
            this.zoom = (float)((double)this.zoom + dWheel * 2.0);
            return true;
        }
        return false;
    }

    @Override
    public void update(double mousex, double mousey) {
        if (this.mouseX != mousex) {
            this.oldMouseX = this.mouseX;
        }
        this.mouseX = mousex;
        if (this.mouseY != mousey) {
            this.oldMouseY = this.mouseY;
        }
        this.mouseY = (int)mousey;
        if (this.allowDrag) {
            double dx = mousex - this.anchorx;
            double dy = mousey - this.anchory;
            switch (this.dragging) {
                case 0: {
                    this.rotx = MathUtils.clampDouble(this.rotx + dy, -90.0, 90.0);
                    this.roty -= dx;
                    this.anchorx = mousex;
                    this.anchory = mousey;
                    break;
                }
                case 1: {
                    this.offsetx += dx;
                    this.offsety += dy;
                    this.anchorx = mousex;
                    this.anchory = mousey;
                    break;
                }
            }
        }
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible) {
            double i = this.centerX() + this.offsetx;
            double j = this.bottom() - 5.0 + this.offsety;
            float mouse_x = (float)(this.guiLeft - this.oldMouseX + 281.0 + this.offsetx);
            float mouse_y = (float)(this.guiTop - this.oldMouseY + 25.0 + this.offsety);
            this.renderEntityInInventory(i, j, mouse_x, mouse_y, this.zoom, this.livingEntity);
        }
    }

    public void renderEntityInInventory(double posX, double posY, float mouseX, float mouseY, float scale, LivingEntity pLivingEntity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_((float)posX, (float)posY, 1050.0f);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_252880_(0.0f, 0.0f, 1000.0f);
        posestack1.m_85841_(scale, scale, scale);
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion1 = Axis.f_252529_.m_252977_(f1 * 20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        posestack1.m_252781_(quaternion);
        float yBodyRot = pLivingEntity.f_20883_;
        float yRot = pLivingEntity.m_146908_();
        float xRot = pLivingEntity.m_146909_();
        float yHeadRotO = pLivingEntity.f_20886_;
        float yHeadRot = pLivingEntity.f_20885_;
        pLivingEntity.f_20883_ = 180.0f + f * 20.0f;
        pLivingEntity.m_146922_(180.0f + f * 40.0f);
        pLivingEntity.m_146926_(-f1 * 20.0f);
        pLivingEntity.f_20885_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20886_ = pLivingEntity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.conjugate();
        entityrenderdispatcher.m_252923_(quaternion1);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)pLivingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        pLivingEntity.f_20883_ = yBodyRot;
        pLivingEntity.m_146922_(yRot);
        pLivingEntity.m_146926_(xRot);
        pLivingEntity.f_20886_ = yHeadRotO;
        pLivingEntity.f_20885_ = yHeadRot;
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    @Override
    public float getZLevel() {
        return 0.0f;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        return this;
    }

    @Override
    public List<Component> getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setAllowDrag(boolean allowDrag) {
        this.allowDrag = allowDrag;
    }

    public void setAllowZoom(boolean allowZoom) {
        this.allowZoom = allowZoom;
    }

    public void setOffsetx(double offsetx) {
        this.offsetx = offsetx;
    }

    public void setOffsety(double offsety) {
        this.offsety = offsety;
    }

    public void setGuiLeft(double guiLeft) {
        this.guiLeft = guiLeft;
    }

    public void setGuiTop(double guiTop) {
        this.guiTop = guiTop;
    }
}

