/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.model.helper;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.math.Transformation;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lehjr.numina.client.event.ModelBakeEventHandler;
import lehjr.numina.client.model.helper.ModelHelper;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.render.modelspec.JavaModelSpec;
import lehjr.numina.common.capabilities.render.modelspec.JavaPartSpec;
import lehjr.numina.common.capabilities.render.modelspec.MorphTarget;
import lehjr.numina.common.capabilities.render.modelspec.NuminaModelSpecRegistry;
import lehjr.numina.common.capabilities.render.modelspec.ObjModelSpec;
import lehjr.numina.common.capabilities.render.modelspec.ObjPartSpec;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import lehjr.numina.common.capabilities.render.modelspec.SpecBinding;
import lehjr.numina.common.capabilities.render.modelspec.SpecType;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public enum ModelSpecLoader {
    INSTANCE;

    static final String MODEL_SPEC = "modelSpec";
    static final String SPEC_NAME = "specName";
    static final String TYPE = "type";
    static final String DEFAULT = "default";
    static final String GLOW = "glow";
    static final String BINDING = "binding";
    static final String BINDINGS = "bindings";
    static final String PARTS = "parts";
    static final String PART = "part";
    static final String MODELS = "models";
    static final String MODEL = "model";
    static final String COLOR = "color";
    static final String DISPLAY = "display";
    static final String TRANSFORMATION_MATRIX = "transformationMatrix";
    static final String FILE = "file";
    static final String NAME = "name";
    static final String BODY = "body";
    static final String LEGS = "legs";
    static final String TEXTURE = "texture";
    static final ResourceLocation ignored;
    static final Vector3f ZERO;
    static final Vector3f ONE;

    ResourceManager getManager() {
        return Minecraft.m_91087_().m_91098_();
    }

    public void parse() {
        ResourceManager manager = this.getManager();
        try {
            Map modelSpecFiles = manager.m_214159_("modelspec", resourceLocation -> resourceLocation.m_135815_().endsWith(".json"));
            for (Map.Entry entry : modelSpecFiles.entrySet()) {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                JsonElement object = JsonParser.parseReader((Reader)reader);
                if (object instanceof JsonObject && ((JsonObject)object).has(MODEL_SPEC)) {
                    this.parseFile(((JsonObject)object).getAsJsonObject(MODEL_SPEC));
                } else {
                    NuminaLogger.logError(((ResourceLocation)entry.getKey()).toString() + " not a valid ModelSpec file");
                }
                reader.close();
            }
        }
        catch (Exception e) {
            NuminaLogger.logException("failed to load ModelSpec", e);
        }
        NuminaLogger.logDebug("Finished loading model specs");
    }

    void parseFile(JsonObject json) {
        boolean isDefault;
        String specName = json.getAsJsonPrimitive(SPEC_NAME).getAsString();
        String specTypeString = json.getAsJsonPrimitive(TYPE).getAsString();
        SpecType specType = SpecType.getTypeFromName(specTypeString);
        boolean bl = isDefault = json.has(DEFAULT) && json.get(DEFAULT).getAsBoolean();
        if (specType == null) {
            NuminaLogger.logDebug("model spec loader spec type: NULL " + json);
            return;
        }
        switch (specType) {
            case HANDHELD_OBJ_MODEL: {
                NuminaLogger.logDebug("model spec loader spec type: HANDHELD_OBJ_MODEL " + json);
                if (json.has(MODELS) && json.get(MODELS).isJsonArray()) {
                    json.getAsJsonArray(MODELS).iterator().forEachRemaining(jsonElement -> this.parseObjModelSpec(jsonElement.getAsJsonObject(), SpecType.HANDHELD_OBJ_MODEL, specName, isDefault, false));
                    break;
                }
                if (!json.has(MODEL)) break;
                this.parseObjModelSpec(json.get(MODEL).getAsJsonObject(), SpecType.HANDHELD_OBJ_MODEL, specName, isDefault, true);
                break;
            }
            case ARMOR_SKIN: {
                NuminaLogger.logDebug("model spec loader spec type: ARMOR_SKIN " + json);
                JavaModelSpec javaModel = new JavaModelSpec(specName, isDefault);
                ModelSpecLoader.parseArmorJavaModelSpec(json, javaModel);
                break;
            }
            case ARMOR_OBJ_MODEL: {
                NuminaLogger.logDebug("model spec loader spec type: ARMOR_OBJ_MODEL " + json);
                if (json.has(MODELS) && json.get(MODELS).isJsonArray()) {
                    json.getAsJsonArray(MODELS).iterator().forEachRemaining(jsonElement -> this.parseObjModelSpec(jsonElement.getAsJsonObject(), SpecType.ARMOR_OBJ_MODEL, specName, isDefault, false));
                    break;
                }
                if (!json.has(MODEL)) break;
                this.parseObjModelSpec(json.get(MODEL).getAsJsonObject(), SpecType.ARMOR_OBJ_MODEL, specName, isDefault, true);
                break;
            }
            case HANDHELD_JAVA_MODEL: {
                NuminaLogger.logDebug("model spec loader spec type: HANDHELD_JAVA_MODEL " + json);
                JavaModelSpec javaModel = new JavaModelSpec(specName, isDefault);
                ModelSpecLoader.parseHandHeldJavaModel(javaModel, json);
                break;
            }
            case NONE: {
                NuminaLogger.logDebug("model spec loader found NONE");
            }
        }
    }

    void parseObjModelSpec(JsonObject modelJson, SpecType specType, String specName, boolean isDefault, boolean isSingle) {
        ResourceLocation modelLocation = new ResourceLocation(modelJson.get(FILE).getAsString());
        ModelBakeEventHandler.INSTANCE.addLocation(modelLocation);
        if (!isSingle) {
            specName = this.specName(modelLocation);
        }
        this.parseObjModelSpec(modelJson, specType, specName, isDefault, modelLocation);
    }

    void parseObjModelSpec(JsonObject modelJson, SpecType specType, String specName, boolean isDefault, ResourceLocation modelLocation) {
        Transformation modelTransform = Transformation.m_121093_();
        ItemTransforms itemTransforms = ItemTransforms.f_111786_;
        if (modelJson.has(DISPLAY) && modelJson.get(DISPLAY) instanceof JsonObject) {
            itemTransforms = ModelSpecLoader.parseItemTransforms(modelJson.getAsJsonObject(DISPLAY));
        } else if (modelJson.has(TRANSFORMATION_MATRIX)) {
            modelTransform = ModelSpecLoader.getTransform(modelJson.getAsJsonObject(TRANSFORMATION_MATRIX));
        }
        ObjModelSpec modelspec = new ObjModelSpec(modelLocation, itemTransforms, specName, isDefault, specType);
        modelspec.setModelTransform(modelTransform);
        ModelSpecLoader.getReg().put(modelspec.getName(), modelspec);
        if (modelJson.has(BINDINGS) && modelJson.get(BINDINGS) instanceof JsonArray) {
            modelJson.getAsJsonArray(BINDINGS).iterator().forEachRemaining(jsonElement -> ModelSpecLoader.parseObjModelBinding(specName, jsonElement.getAsJsonObject()));
        } else if (modelJson.has(BINDING) && modelJson.get(BINDING) instanceof JsonObject) {
            ModelSpecLoader.parseObjModelBinding(specName, modelJson.get(BINDING).getAsJsonObject());
        }
    }

    static void parseObjModelBinding(String specName, JsonObject bindingJson) {
        SpecBinding binding = ModelSpecLoader.getBinding(bindingJson);
        if (bindingJson.has(PARTS) && bindingJson.get(PARTS).isJsonArray()) {
            bindingJson.getAsJsonArray(PARTS).iterator().forEachRemaining(jsonElement -> ModelSpecLoader.parseObjModelPart(specName, jsonElement.getAsJsonObject(), binding));
        } else if (bindingJson.has(PART)) {
            ModelSpecLoader.parseObjModelPart(specName, bindingJson.get(PART).getAsJsonObject(), binding);
        }
    }

    static void parseObjModelPart(String specName, JsonObject partJson, SpecBinding binding) {
        ObjModelSpec objModelSpec = (ObjModelSpec)ModelSpecLoader.getReg().get(specName);
        String name = partJson.get(NAME).getAsString();
        boolean glow = partJson.has(GLOW) && partJson.get(GLOW).getAsBoolean();
        Color color = partJson.has(COLOR) ? ModelSpecLoader.parseColor(partJson.get(COLOR).getAsString()) : Color.WHITE;
        ModelSpecLoader.getReg().addPart(new ObjPartSpec(objModelSpec, binding, name, color, (Boolean)glow));
    }

    static void parseHandHeldJavaModel(JavaModelSpec javaModel, JsonObject json) {
        JavaModelSpec existingspec = ModelSpecLoader.getReg().put(javaModel.getName(), javaModel);
        if (json.has(MODELS) && json.get(MODELS).isJsonArray()) {
            json.getAsJsonArray(MODELS).iterator().forEachRemaining(jsonElement -> {
                JsonObject modelObject = jsonElement.getAsJsonObject();
                ModelSpecLoader.parseJavaModelPartsAndBindings(existingspec, modelObject);
            });
        } else if (json.getAsJsonObject().has(MODEL)) {
            JsonObject modelObject = json.get(MODEL).getAsJsonObject();
            ModelSpecLoader.parseJavaModelPartsAndBindings(existingspec, modelObject);
        }
    }

    static void parseJavaModelPartsAndBindings(JavaModelSpec javaModel, JsonObject modelObject) {
        if (modelObject.getAsJsonObject().has(BINDINGS) && modelObject.get(BINDINGS).isJsonArray()) {
            modelObject.get(BINDINGS).getAsJsonArray().iterator().forEachRemaining(bindingElement -> ModelSpecLoader.parseJavaModelBinding(javaModel, bindingElement.getAsJsonObject()));
        } else if (modelObject.has(BINDING)) {
            ModelSpecLoader.parseJavaModelBinding(javaModel, modelObject.get(BINDING).getAsJsonObject());
        }
    }

    static void parseJavaModelBinding(JavaModelSpec javaModel, JsonObject bindingJson) {
        SpecBinding binding = ModelSpecLoader.getBinding(bindingJson);
        if (bindingJson.has(PARTS) && bindingJson.get(PARTS).isJsonArray()) {
            bindingJson.getAsJsonArray(PARTS).iterator().forEachRemaining(jsonElement -> ModelSpecLoader.parseJavaModelPart(javaModel, jsonElement.getAsJsonObject(), binding));
        } else if (bindingJson.has(PART)) {
            ModelSpecLoader.parseJavaModelPart(javaModel, bindingJson.get(PART).getAsJsonObject(), binding);
        }
    }

    static void parseJavaModelPart(JavaModelSpec javaModel, JsonObject partJson, SpecBinding binding) {
        String name = partJson.get(NAME).getAsString();
        boolean glow = partJson.has(GLOW) && partJson.get(GLOW).getAsBoolean();
        Color color = partJson.has(COLOR) ? ModelSpecLoader.parseColor(partJson.get(COLOR).getAsString()) : Color.WHITE;
        javaModel.put(new JavaPartSpec(javaModel, binding, color, name, ignored, glow), name);
    }

    public static void parseArmorJavaModelSpec(JsonObject json, JavaModelSpec javaModelSpec) {
        JavaModelSpec existingspec = ModelSpecLoader.getReg().put(javaModelSpec.getName(), javaModelSpec);
        JsonObject bodyJson = json.get(BODY).getAsJsonObject();
        JsonObject legsJson = json.get(LEGS).getAsJsonObject();
        Color bodyColor = bodyJson.has(COLOR) ? ModelSpecLoader.parseColor(bodyJson.get(COLOR).getAsString()) : Color.WHITE;
        Color legsColor = legsJson.has(COLOR) ? ModelSpecLoader.parseColor(legsJson.get(COLOR).getAsString()) : Color.WHITE;
        ResourceLocation bodyTexture = new ResourceLocation(bodyJson.get(TEXTURE).getAsString());
        ResourceLocation legsTexture = new ResourceLocation(legsJson.get(TEXTURE).getAsString());
        ModelSpecLoader.putJavaModelPartSpecs(false, existingspec, bodyTexture, bodyColor);
        ModelSpecLoader.putJavaModelPartSpecs(true, existingspec, legsTexture, legsColor);
    }

    String makeArmorTexturePartSpecName(EquipmentSlot slot, MorphTarget target) {
        return slot.m_20751_() + "." + target.name();
    }

    static void putJavaModelPartSpecs(boolean isLegs, JavaModelSpec javaModelSpec, ResourceLocation textureLocation, Color color) {
        if (isLegs) {
            EquipmentSlot slot = EquipmentSlot.LEGS;
            for (MorphTarget target : MorphTarget.getMorphTargetsFromEquipmentSlot(slot)) {
                String partName = INSTANCE.makeArmorTexturePartSpecName(slot, target);
                javaModelSpec.put(new JavaPartSpec((SpecBase)javaModelSpec, new SpecBinding(target, slot, "all"), color, partName, textureLocation), partName);
            }
        } else {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.equals((Object)EquipmentSlot.LEGS) || slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                for (MorphTarget target : MorphTarget.getMorphTargetsFromEquipmentSlot(slot)) {
                    String partName = INSTANCE.makeArmorTexturePartSpecName(slot, target);
                    javaModelSpec.put(new JavaPartSpec((SpecBase)javaModelSpec, new SpecBinding(target, slot, "all"), color, partName, textureLocation), partName);
                }
            }
        }
    }

    public static ItemTransforms parseItemTransforms(JsonObject jsonObject) {
        HashMap<ItemDisplayContext, ItemTransform> itemTransformMap = new HashMap<ItemDisplayContext, ItemTransform>();
        for (ItemDisplayContext type : ItemDisplayContext.values()) {
            ItemTransform transform;
            if (jsonObject.has(type.name())) {
                try {
                    transform = ModelSpecLoader.getItemTransform(jsonObject.get(type.name()).getAsJsonObject());
                }
                catch (Exception ignored) {
                    transform = ItemTransform.f_111754_;
                }
            } else {
                transform = ItemTransform.f_111754_;
            }
            itemTransformMap.put(type, transform);
        }
        return new ItemTransforms((ItemTransform)itemTransformMap.get(ItemDisplayContext.THIRD_PERSON_LEFT_HAND), (ItemTransform)itemTransformMap.get(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND), (ItemTransform)itemTransformMap.get(ItemDisplayContext.FIRST_PERSON_LEFT_HAND), (ItemTransform)itemTransformMap.get(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND), (ItemTransform)itemTransformMap.get(ItemDisplayContext.HEAD), (ItemTransform)itemTransformMap.get(ItemDisplayContext.GUI), (ItemTransform)itemTransformMap.get(ItemDisplayContext.GROUND), (ItemTransform)itemTransformMap.get(ItemDisplayContext.FIXED), ImmutableMap.of());
    }

    public static Transformation getTransform(JsonObject transformationJson) {
        Vector3f translation = ModelSpecLoader.parseVector(transformationJson.get("translation"), ZERO);
        Vector3f rotation = ModelSpecLoader.parseVector(transformationJson.get("rotation"), ZERO);
        Vector3f scale = ModelSpecLoader.parseVector(transformationJson.get("scale"), ONE);
        return ModelHelper.getTransform(translation, rotation, scale);
    }

    public static SpecBinding getBinding(JsonObject bindingJson) {
        NuminaLogger.logDebug("bindingJson: " + bindingJson);
        return new SpecBinding(bindingJson.has("target") ? MorphTarget.getMorph(bindingJson.get("target").getAsString()) : null, bindingJson.has("itemSlot") ? EquipmentSlot.m_20747_((String)bindingJson.get("itemSlot").getAsString().toLowerCase()) : null, bindingJson.has("itemState") ? bindingJson.get("itemState").getAsString() : "all");
    }

    static ItemTransform getItemTransform(JsonObject transformationJson) {
        Vector3f translation = ModelSpecLoader.parseVector(transformationJson.get("translation"), ZERO);
        Vector3f rotation = ModelSpecLoader.parseVector(transformationJson.get("rotation"), ZERO);
        Vector3f scale = ModelSpecLoader.parseVector(transformationJson.get("scale"), ONE);
        return new ItemTransform(rotation, translation, scale);
    }

    @Nullable
    public static Vector3f parseVector(JsonElement object, Vector3f fallback) {
        try {
            String s = object.getAsString();
            String[] ss = s.split(",");
            float x = Float.parseFloat(ss[0]);
            float y = Float.parseFloat(ss[1]);
            float z = Float.parseFloat(ss[2]);
            return new Vector3f(x, y, z);
        }
        catch (Exception e) {
            return fallback;
        }
    }

    static Color parseColor(String colorString) {
        return Color.fromARGBHexString(colorString);
    }

    static NuminaModelSpecRegistry getReg() {
        return NuminaModelSpecRegistry.getInstance();
    }

    String specName(ResourceLocation location) {
        String path = location.m_135815_();
        if (path.contains("/")) {
            path = location.m_135815_().substring(path.lastIndexOf("/") + 1);
        }
        return path;
    }

    static {
        ignored = new ResourceLocation("numina", "ignored");
        ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
        ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    }
}

