/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.base;

import lehjr.numina.client.sound.SoundDictionary;
import lehjr.numina.common.base.NuminaObjects;
import lehjr.numina.common.capabilities.heat.IHeatStorage;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.player.keystates.IPlayerKeyStates;
import lehjr.numina.common.capabilities.player.keystates.PlayerKeyStateWrapper;
import lehjr.numina.common.capabilities.render.IModelSpec;
import lehjr.numina.common.capabilities.render.chameleon.IChameleon;
import lehjr.numina.common.capabilities.render.color.IColorTag;
import lehjr.numina.common.capabilities.render.highlight.IHighlight;
import lehjr.numina.common.config.ConfigHelper;
import lehjr.numina.common.config.NuminaSettings;
import lehjr.numina.common.entity.NuminaArmorStand;
import lehjr.numina.common.event.LogoutEventHandler;
import lehjr.numina.common.event.PlayerUpdateHandler;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.recipe.RecipeSerializersRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="numina")
public class Numina {
    public Numina() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)NuminaSettings.CLIENT_SPEC, ConfigHelper.setupConfigFile("numina-client-only.toml", "numina").getAbsolutePath());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)NuminaSettings.SERVER_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::addEntityAttributes);
        modEventBus.addListener(this::registerCapabilities);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SoundDictionary.NUMINA_SOUND_EVENTS.register(modEventBus);
        NuminaObjects.NUMINA_ITEMS.register(modEventBus);
        NuminaObjects.register(modEventBus);
        NuminaObjects.NUMINA_BLOCKS.register(modEventBus);
        NuminaObjects.TILE_TYPES.register(modEventBus);
        NuminaObjects.ENTITY_TYPES.register(modEventBus);
        NuminaObjects.MENU_TYPES.register(modEventBus);
        RecipeSerializersRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new LogoutEventHandler());
        modEventBus.addListener(event -> {
            new RuntimeException("Got config " + event.getConfig() + " name " + event.getConfig().getModId() + ":" + event.getConfig().getFileName());
            ModConfig config = event.getConfig();
            if (config.getSpec() == NuminaSettings.SERVER_SPEC) {
                NuminaSettings.getModuleConfig().setServerConfig(config);
            }
        });
    }

    public void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)NuminaObjects.ARMOR_STAND__ENTITY_TYPE.get(), NuminaArmorStand.createAttributes().m_22265_());
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IHeatStorage.class);
        event.register(IColorTag.class);
        event.register(IPowerModule.class);
        event.register(IModelSpec.class);
        event.register(IHighlight.class);
        event.register(IChameleon.class);
        event.register(IPlayerKeyStates.class);
    }

    private void setup(FMLCommonSetupEvent event) {
        NuminaPackets.registerNuminaPackets();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerUpdateHandler());
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player) || event.getObject() == null) {
            return;
        }
        event.addCapability(new ResourceLocation("numina", "player_keystates1"), (ICapabilityProvider)new PlayerKeyStateWrapper((Player)event.getObject()));
    }
}

