/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.inventory.modularitem;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public interface IModularItem
extends IItemHandler,
IItemHandlerModifiable {
    public void setRangedWrapperMap(Map<ModuleCategory, NuminaRangedWrapper> var1);

    public boolean isModuleValid(@Nonnull ItemStack var1);

    public boolean isModuleInstalled(ResourceLocation var1);

    default public boolean isModuleInstalled(@Nonnull ItemStack module) {
        return module.getCapability(NuminaCapabilities.POWER_MODULE).isPresent() && this.isModuleInstalled(ItemUtils.getRegistryName(module));
    }

    default public boolean isModuleInstalled(Item item) {
        return this.isModuleInstalled(ItemUtils.getRegistryName(item));
    }

    public boolean isModuleOnline(ResourceLocation var1);

    public void toggleModule(ResourceLocation var1, boolean var2);

    @Nullable
    public Pair<Integer, Integer> getRangeForCategory(ModuleCategory var1);

    public List<ResourceLocation> getInstalledModuleNames();

    public NonNullList<ItemStack> getInstalledModules();

    public NonNullList<ItemStack> getInstalledModulesOfType(Class<? extends IPowerModule> var1);

    @Nonnull
    public ItemStack getOnlineModuleOrEmpty(ResourceLocation var1);

    @Nonnull
    public ItemStack getModularItemStack();

    public void tick(Player var1);

    default public String formatInfo(String string, double value) {
        return string + "\t" + StringUtils.formatNumberShort(value);
    }

    public boolean setModuleTweakDouble(ResourceLocation var1, String var2, double var3);

    default public int findInstalledModule(@Nonnull ItemStack module) {
        ResourceLocation registryName = ItemUtils.getRegistryName(module);
        return this.findInstalledModule(registryName);
    }

    default public int findInstalledModule(ResourceLocation registryName) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack testStack = this.getStackInSlot(i);
            if (testStack.m_41619_() || !ItemUtils.getRegistryName(testStack).equals((Object)registryName)) continue;
            return i;
        }
        return -1;
    }
}

