/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.player.keystates;

import lehjr.numina.common.capabilities.CapabilityUpdate;
import lehjr.numina.common.capabilities.player.keystates.IPlayerKeyStates;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.nbt.ByteTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerKeyStateStorage
implements IPlayerKeyStates,
INBTSerializable<ByteTag>,
CapabilityUpdate {
    LazyOptional<PlayerKeyStateStorage> instance = LazyOptional.of(() -> this);
    private boolean forwardKeyState = false;
    private boolean reverseKeyState = false;
    private boolean strafeLeftKeyState = false;
    private boolean strafeRightKeyState = false;
    private boolean downKeyState = false;
    private boolean jumpKeyState = false;

    public PlayerKeyStateStorage() {
        this.forwardKeyState = false;
        this.reverseKeyState = false;
        this.strafeLeftKeyState = false;
        this.strafeRightKeyState = false;
        this.downKeyState = false;
        this.jumpKeyState = false;
    }

    public PlayerKeyStateStorage(boolean forwardKeyState, boolean reverseKeyState, boolean strafeLeftKeyState, boolean strafeRightKeyState, boolean downKeyState, boolean jumpKeyState) {
        this.forwardKeyState = forwardKeyState;
        this.reverseKeyState = reverseKeyState;
        this.strafeLeftKeyState = strafeLeftKeyState;
        this.strafeRightKeyState = strafeRightKeyState;
        this.downKeyState = downKeyState;
        this.jumpKeyState = jumpKeyState;
    }

    public PlayerKeyStateStorage(byte packedKeyStates) {
        boolean[] boolArray = MathUtils.byteToBooleanArray(packedKeyStates);
        this.forwardKeyState = boolArray[0];
        this.reverseKeyState = boolArray[1];
        this.strafeLeftKeyState = boolArray[2];
        this.strafeRightKeyState = boolArray[3];
        this.downKeyState = boolArray[4];
        this.jumpKeyState = boolArray[5];
    }

    @Override
    public boolean getForwardKeyState() {
        return this.forwardKeyState;
    }

    @Override
    public void setForwardKeyState(boolean state) {
        this.forwardKeyState = state;
    }

    @Override
    public boolean getReverseKeyState() {
        return this.reverseKeyState;
    }

    @Override
    public void setReverseKeyState(boolean state) {
        this.reverseKeyState = state;
    }

    @Override
    public boolean getLeftStrafeKeyState() {
        return this.strafeLeftKeyState;
    }

    @Override
    public void setLeftStrafeKeyState(boolean state) {
        this.strafeLeftKeyState = state;
    }

    @Override
    public boolean getRightStrafeKeyState() {
        return this.strafeRightKeyState;
    }

    @Override
    public void setRightStrafeKeyState(boolean state) {
        this.strafeRightKeyState = state;
    }

    @Override
    public boolean getJumpKeyState() {
        return this.jumpKeyState;
    }

    @Override
    public void setJumpKeyState(boolean state) {
        this.jumpKeyState = state;
    }

    @Override
    public void setDownKeyState(boolean state) {
        this.downKeyState = state;
    }

    @Override
    public boolean getDownKeyState() {
        return this.downKeyState;
    }

    public String toString() {
        return "forwardKeyState: " + this.getForwardKeyState() + ", reverseKeyState: " + this.getReverseKeyState() + ", leftStrafeKeyState: " + this.getLeftStrafeKeyState() + ",  rightStrafeKeyState: " + this.getRightStrafeKeyState() + ", downKeyState: " + this.getDownKeyState() + ", jumpKeyState: " + this.getJumpKeyState();
    }

    public ByteTag serializeNBT() {
        boolean[] boolArray = new boolean[]{this.getForwardKeyState(), this.getReverseKeyState(), this.getLeftStrafeKeyState(), this.getRightStrafeKeyState(), this.getDownKeyState(), this.getJumpKeyState(), false, false};
        byte byteOut = MathUtils.boolArrayToByte(boolArray);
        return ByteTag.m_128266_((byte)byteOut);
    }

    public void deserializeNBT(ByteTag nbt) {
        if (nbt instanceof ByteTag) {
            byte byteOut = nbt.m_7063_();
            boolean[] boolArray = MathUtils.byteToBooleanArray(byteOut);
            this.setForwardKeyState(boolArray[0]);
            this.setReverseKeyState(boolArray[1]);
            this.setLeftStrafeKeyState(boolArray[2]);
            this.setRightStrafeKeyState(boolArray[3]);
            this.setDownKeyState(boolArray[4]);
            this.setJumpKeyState(boolArray[5]);
        }
    }

    @Override
    public void loadCapValues() {
    }

    @Override
    public void onValueChanged() {
    }
}

