/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import java.util.Objects;
import lehjr.numina.common.capabilities.render.modelspec.NuminaModelSpecRegistry;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import lehjr.numina.common.capabilities.render.modelspec.SpecBinding;
import lehjr.numina.common.math.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public abstract class PartSpecBase {
    public final SpecBase spec;
    final String partName;
    final SpecBinding binding;
    Integer defaultcolorindex;
    private final boolean defaultglow;

    public PartSpecBase(SpecBase spec, SpecBinding binding, String partName, Color color, Boolean defaultglow) {
        this.spec = spec;
        this.partName = partName;
        this.binding = binding;
        SpecBase other = (SpecBase)NuminaModelSpecRegistry.getInstance().get(spec.getName());
        int defaultcolorindex = other.addColorIfNotExist(color);
        this.defaultcolorindex = defaultcolorindex >= 0 ? Integer.valueOf(defaultcolorindex) : Integer.valueOf(0);
        this.defaultglow = defaultglow != null ? defaultglow : false;
    }

    abstract String getNamePrefix();

    public Component getDisaplayName() {
        return Component.m_237115_((String)(this.getNamePrefix() + this.spec.getOwnName() + "." + this.partName + ".partName"));
    }

    public String getPartName() {
        return this.partName;
    }

    public boolean hasArmorEquipmentSlot(EquipmentSlot slot) {
        return this.getBinding().getSlot().equals((Object)slot) && slot.m_20743_() == EquipmentSlot.Type.ARMOR;
    }

    public boolean getGlow() {
        return this.defaultglow;
    }

    public boolean getGlow(CompoundTag nbt) {
        return nbt.m_128441_("glow") ? nbt.m_128471_("glow") : this.defaultglow;
    }

    public void setGlow(CompoundTag nbt, boolean g) {
        if (g == this.defaultglow) {
            nbt.m_128473_("glow");
        } else {
            nbt.m_128379_("glow", g);
        }
    }

    public boolean isForHand(HumanoidArm arm, LivingEntity entity) {
        if (this.binding.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            return false;
        }
        return this.binding.getTarget().getHandFromEquipmentSlot(entity).equals((Object)arm);
    }

    public SpecBinding getBinding() {
        return this.binding;
    }

    public int getDefaultColorIndex() {
        return this.defaultcolorindex;
    }

    public int getColorIndex(CompoundTag nbt) {
        return nbt.m_128441_("colorindex") ? nbt.m_128451_("colorindex") : this.defaultcolorindex.intValue();
    }

    public void setColorIndex(CompoundTag nbt, int c) {
        if (c == this.defaultcolorindex) {
            nbt.m_128473_("colorindex");
        } else {
            nbt.m_128405_("colorindex", c);
        }
    }

    public void setModel(CompoundTag nbt, SpecBase model) {
        String modelString = (String)NuminaModelSpecRegistry.getInstance().getName(model);
        this.setModel(nbt, modelString != null ? modelString : model.getOwnName());
    }

    public void setModel(CompoundTag nbt, String modelname) {
        nbt.m_128359_("model", modelname);
    }

    public void setPart(CompoundTag nbt) {
        nbt.m_128359_("part", this.partName);
    }

    public CompoundTag multiSet(CompoundTag nbt, Integer colorIndex, Boolean glow) {
        this.setGlow(nbt, glow != null ? glow : false);
        this.setPart(nbt);
        this.setModel(nbt, this.spec);
        this.setColorIndex(nbt, colorIndex != null ? colorIndex : this.defaultcolorindex);
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartSpecBase that = (PartSpecBase)o;
        return Objects.equals(this.spec, that.spec) && Objects.equals(this.partName, that.partName) && Objects.equals(this.binding, that.binding) && Objects.equals(this.defaultcolorindex, that.defaultcolorindex) && Objects.equals(this.defaultglow, that.defaultglow);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.partName, this.binding, this.defaultcolorindex);
    }
}

