/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets.serverbound;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.clientbound.BlockNamePacketClientBound;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record BlockNamePacketServerBound(ResourceLocation regName) {
    public static void encode(BlockNamePacketServerBound msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(msg.regName);
    }

    public static BlockNamePacketServerBound decode(FriendlyByteBuf packetBuffer) {
        return new BlockNamePacketServerBound(packetBuffer.m_130281_());
    }

    public static void sendToClient(ServerPlayer entity, ResourceLocation regName) {
        NuminaPackets.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new BlockNamePacketClientBound(regName));
    }

    public static class Handler {
        public static void handle(BlockNamePacketServerBound message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                ResourceLocation regName = message.regName;
                if (player != null && regName != null) {
                    ItemUtils.getItemFromEntitySlot((LivingEntity)player, EquipmentSlot.MAINHAND).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(handler -> TagUtils.setModuleResourceLocation(handler.getActiveModule(), "block", regName));
                    BlockNamePacketServerBound.sendToClient(player, regName);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

