/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.puffs;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticle;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class PuffSmokeParticleData<T extends PuffSmokeParticleData<T>>
implements ParticleOptions,
ICustomParticleDataWithSprite<T> {
    boolean stationary;
    float red;
    float green;
    float blue;

    protected static <T extends PuffSmokeParticleData<T>> Codec<T> makeCodec(Constructor<T> constructor) {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("stationary").forGetter(p -> p.stationary), (App)Codec.FLOAT.fieldOf("red").forGetter(p -> Float.valueOf(p.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(p -> Float.valueOf(p.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(p -> Float.valueOf(p.blue))).apply((Applicative)i, constructor::create));
    }

    protected static <T extends PuffSmokeParticleData<T>> ParticleOptions.Deserializer<T> makeDeserializer(final Constructor<T> constructor) {
        return new ParticleOptions.Deserializer<T>(){

            @NotNull
            public T fromCommand(@NotNull ParticleType<T> particleTypeIn, @NotNull StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                boolean stationary = reader.readBoolean();
                reader.expect(' ');
                float red = reader.readFloat();
                reader.expect(' ');
                float green = reader.readFloat();
                reader.expect(' ');
                float blue = reader.readFloat();
                return constructor.create(stationary, red, green, blue);
            }

            @NotNull
            public T fromNetwork(@NotNull ParticleType<T> particleTypeIn, @NotNull FriendlyByteBuf buffer) {
                return constructor.create(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
    }

    protected PuffSmokeParticleData() {
        this(false);
    }

    protected PuffSmokeParticleData(float red, float green, float blue) {
        this(false, red, green, blue);
    }

    protected PuffSmokeParticleData(boolean stationary) {
        this(stationary, -1.0f);
    }

    protected PuffSmokeParticleData(boolean stationary, float brightness) {
        this(stationary, brightness, brightness, brightness);
    }

    protected PuffSmokeParticleData(boolean stationary, float red, float green, float blue) {
        this.stationary = stationary;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @NotNull
    protected abstract CRParticleTypes getParticleType();

    @NotNull
    public ParticleType<?> m_6012_() {
        return this.getParticleType().get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.stationary);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %b %f %f %f", this.getParticleType().parameter(), this.stationary, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public abstract ParticleOptions.Deserializer<T> getDeserializer();

    public abstract Codec<T> getCodec(ParticleType<T> var1);

    public abstract ParticleEngine.SpriteParticleRegistration<T> getMetaFactory();

    public abstract float getQuadSize();

    public static PuffSmokeParticleData<?> create(boolean small, boolean stationary, @NotNull DyeColor color) {
        float idx = -(3 + color.m_41060_());
        return PuffSmokeParticleData.create(small, stationary, idx, idx, idx);
    }

    public static PuffSmokeParticleData<?> create(boolean small, boolean stationary, float red, float green, float blue) {
        if (small) {
            return new Small(stationary, red, green, blue);
        }
        return new Medium(stationary, red, green, blue);
    }

    public static PuffSmokeParticleData<?> create(boolean small, boolean stationary) {
        if (small) {
            return new Small(stationary);
        }
        return new Medium(stationary);
    }

    @FunctionalInterface
    protected static interface Constructor<T extends PuffSmokeParticleData<T>> {
        @Contract(value="_, _, _, _ -> new")
        public T create(boolean var1, float var2, float var3, float var4);
    }

    public static class Small
    extends PuffSmokeParticleData<Small> {
        public static final Codec<Small> CODEC = Small.makeCodec(Small::new);
        public static final ParticleOptions.Deserializer<Small> DESERIALIZER = Small.makeDeserializer(Small::new);

        public Small() {
        }

        public Small(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Small(boolean stationary) {
            super(stationary);
        }

        public Small(boolean stationary, float brightness) {
            super(stationary, brightness);
        }

        public Small(boolean stationary, float red, float green, float blue) {
            super(stationary, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.SMOKE_PUFF_SMALL;
        }

        @Override
        public ParticleOptions.Deserializer<Small> getDeserializer() {
            return DESERIALIZER;
        }

        @Override
        public Codec<Small> getCodec(ParticleType<Small> type) {
            return CODEC;
        }

        @Override
        public ParticleEngine.SpriteParticleRegistration<Small> getMetaFactory() {
            return PuffSmokeParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 0.5f;
        }
    }

    public static class Medium
    extends PuffSmokeParticleData<Medium> {
        public static final Codec<Medium> CODEC = Medium.makeCodec(Medium::new);
        public static final ParticleOptions.Deserializer<Medium> DESERIALIZER = Medium.makeDeserializer(Medium::new);

        public Medium() {
        }

        public Medium(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Medium(boolean stationary) {
            super(stationary);
        }

        public Medium(boolean stationary, float brightness) {
            super(stationary, brightness);
        }

        public Medium(boolean stationary, float red, float green, float blue) {
            super(stationary, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.SMOKE_PUFF_MEDIUM;
        }

        @Override
        public ParticleOptions.Deserializer<Medium> getDeserializer() {
            return DESERIALIZER;
        }

        @Override
        public Codec<Medium> getCodec(ParticleType<Medium> type) {
            return CODEC;
        }

        @Override
        public ParticleEngine.SpriteParticleRegistration<Medium> getMetaFactory() {
            return PuffSmokeParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 1.0f;
        }
    }
}

