/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.common;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.util.ResourceLocationHelper;

public final class TagManager {
    private static ResourceLocation forgeLoc(String path) {
        return ResourceLocationHelper.location("forge", path);
    }

    public static final class EntityTypes {
        public static final TagKey<EntityType<?>> ELEMENTAL_SEVERING_MOBS = EntityTypes.create("elemental_severing_mods");
        public static final TagKey<EntityType<?>> MILK_PRODUCER = EntityTypes.create("milk_producer");

        private static TagKey<EntityType<?>> create(String id) {
            return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createOptionalTagKey(ResourceLocationHelper.resource(id), Collections.emptySet());
        }
    }

    public static final class Blocks {
        public static final TagKey<Block> BRONZE = Blocks.forgeTag("storage_blocks/bronze");
        public static final TagKey<Block> SOUL_STAINED_STEEL = Blocks.forgeTag("storage_blocks/soul_stained_steel");
        public static final TagKey<Block> DRAGONSTEEL_FIRE = Blocks.forgeTag("storage_blocks/dragonsteel_fire");
        public static final TagKey<Block> DRAGONSTEEL_ICE = Blocks.forgeTag("storage_blocks/dragonsteel_ice");
        public static final TagKey<Block> DRAGONSTEEL_LIGHTNING = Blocks.forgeTag("storage_blocks/dragonsteel_lightning");
        public static final TagKey<Block> SOURCE_GEM_BLOCK = Blocks.forgeTag("storage_blocks/source_gem");

        private static TagKey<Block> create(String id) {
            return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).createOptionalTagKey(ResourceLocationHelper.resource(id), Collections.emptySet());
        }

        private static TagKey<Block> forgeTag(String name) {
            return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).createOptionalTagKey(TagManager.forgeLoc(name), Collections.emptySet());
        }
    }

    public static final class Items {
        public static final TagKey<Item> BRONZE = Items.forgeTag("storage_blocks/bronze");
        public static final TagKey<Item> BRONZE_INGOTS = Items.forgeTag("ingots/bronze");
        public static final TagKey<Item> BRONZE_NUGGETS = Items.forgeTag("nuggets/bronze");
        public static final TagKey<Item> CHEESE = Items.forgeTag("food/cheese");
        public static final TagKey<Item> BOTANIA_LIVINGWOOD_LOGS = Items.create("livingwood_logs");
        public static final TagKey<Item> INGOTS_TERRASTEEL = Items.botaniaTag("terrasteel_ingots");
        public static final TagKey<Item> MYSTICAL_FLOWERS = Items.botaniaTag("mystical_flowers");
        public static final TagKey<Item> DOUBLE_MYSTICAL_FLOWERS = Items.botaniaTag("double_mystical_flowers");
        public static final TagKey<Item> LIVINGWOOD_LOGS = Items.botaniaTag("livingwood_logs");
        public static final TagKey<Item> INGOTS_ELEMENTIUM = Items.botaniaTag("elementium_ingots");
        public static final TagKey<Item> LIVINGWOOD_LOGS_GLIMMERING = Items.botaniaTag("glimmering_livingwood_logs");
        public static final TagKey<Item> SOUL_STAINED_STEEL = Items.forgeTag("storage_blocks/soul_stained_steel");
        public static final TagKey<Item> SOUL_STAINED_STEEL_INGOTS = Items.forgeTag("ingots/soul_stained_steel");
        public static final TagKey<Item> SOUL_STAINED_STEEL_NUGGETS = Items.forgeTag("nuggets/soul_stained_steel");
        public static final TagKey<Item> WITHER_BONES = Items.forgeTag("bones/wither");
        public static final TagKey<Item> DRAGONSTEEL_FIRE = Items.forgeTag("storage_blocks/dragonsteel_fire");
        public static final TagKey<Item> DRAGONSTEEL_FIRE_INGOTS = Items.forgeTag("ingots/dragonsteel_fire");
        public static final TagKey<Item> DRAGONSTEEL_ICE = Items.forgeTag("storage_blocks/dragonsteel_ice");
        public static final TagKey<Item> DRAGONSTEEL_ICE_INGOTS = Items.forgeTag("ingots/dragonsteel_ice");
        public static final TagKey<Item> DRAGONSTEEL_LIGHTNING = Items.forgeTag("storage_blocks/dragonsteel_lightning");
        public static final TagKey<Item> DRAGONSTEEL_LIGHTNING_INGOTS = Items.forgeTag("ingots/dragonsteel_lightning");
        public static final TagKey<Item> SOURCE_GEM = Items.forgeTag("gems/source_gem");
        public static final TagKey<Item> SOURCE_GEM_BLOCK = Items.forgeTag("storage_blocks/source_gem");

        private static TagKey<Item> create(String id) {
            return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createOptionalTagKey(ResourceLocationHelper.resource(id), Collections.emptySet());
        }

        private static TagKey<Item> forgeTag(String name) {
            return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createOptionalTagKey(TagManager.forgeLoc(name), Collections.emptySet());
        }

        private static TagKey<Item> botaniaTag(String name) {
            return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createOptionalTagKey(ModIntegration.botaniaLoc(name), Collections.emptySet());
        }
    }
}

