/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon.material;

import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import tcintegrations.common.TagManager;
import tcintegrations.data.BaseRecipeProvider;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.data.tcon.material.MaterialIds;
import tcintegrations.items.TCIntegrationsItems;

public class MaterialRecipeProvider
extends BaseRecipeProvider
implements IMaterialRecipeHelper {
    public MaterialRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public String m_6055_() {
        return "TCIntegrations - TCon Material Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addMaterialItems(consumer);
        this.addMaterialSmeltery(consumer);
    }

    private void addMaterialItems(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        Consumer botaniaConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")});
        Consumer aquacultureConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")});
        Consumer malumConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")});
        Consumer brassConsumer = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/brass")});
        Consumer ifdConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("iceandfire")});
        Consumer adAstraConsumer = this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.modLoaded("ad_astra"), this.modLoaded("beyond_earth")})});
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.livingWood, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.BOTANIA_LIVINGWOOD_PLANKS}), 1, 1, folder + "livingwood/planks");
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.livingWood, Ingredient.m_204132_(TagManager.Items.BOTANIA_LIVINGWOOD_LOGS), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)ModIntegration.BOTANIA_LIVINGWOOD_PLANKS)), folder + "livingwood/logs");
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.livingRock, Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModIntegration.LIVING_ROCK)}), 1, 1, folder + "livingrock");
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.manaString, Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModIntegration.MANA_STRING)}), 1, 1, folder + "manastring");
        this.metalMaterialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.manaSteel, folder, MaterialIds.manaSteel.m_135815_(), true);
        this.metalMaterialRecipe(aquacultureConsumer, (MaterialVariantId)MaterialIds.neptunium, folder, MaterialIds.neptunium.m_135815_(), true);
        this.metalMaterialRecipe(malumConsumer, (MaterialVariantId)MaterialIds.soulStainedSteel, folder, MaterialIds.soulStainedSteel.m_135815_(), true);
        this.metalMaterialRecipe(brassConsumer, (MaterialVariantId)MaterialIds.brass, folder, MaterialIds.brass.m_135815_(), true);
        this.metalMaterialRecipe(ifdConsumer, (MaterialVariantId)MaterialIds.dragonsteelFire, folder, MaterialIds.dragonsteelFire.m_135815_(), true);
        this.metalMaterialRecipe(ifdConsumer, (MaterialVariantId)MaterialIds.dragonsteelIce, folder, MaterialIds.dragonsteelIce.m_135815_(), true);
        this.metalMaterialRecipe(ifdConsumer, (MaterialVariantId)MaterialIds.dragonsteelLightning, folder, MaterialIds.dragonsteelLightning.m_135815_(), true);
        this.metalMaterialRecipe(adAstraConsumer, (MaterialVariantId)MaterialIds.desh, folder, MaterialIds.desh.m_135815_(), true);
        this.metalMaterialRecipe(adAstraConsumer, (MaterialVariantId)MaterialIds.calorite, folder, MaterialIds.calorite.m_135815_(), true);
        this.metalMaterialRecipe(adAstraConsumer, (MaterialVariantId)MaterialIds.ostrum, folder, MaterialIds.ostrum.m_135815_(), true);
    }

    private void addMaterialSmeltery(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.compatMeltingCasting(consumer, MaterialIds.brass, (FluidObject)TinkerFluids.moltenBrass, folder);
        this.compatMeltingCasting(consumer, MaterialIds.manaSteel, (FluidObject)TCIntegrationsItems.MOLTEN_MANASTEEL, folder);
        this.compatMeltingCasting(consumer, MaterialIds.neptunium, (FluidObject)TCIntegrationsItems.MOLTEN_NEPTUNIUM, folder);
        this.compatMeltingCasting(consumer, MaterialIds.soulStainedSteel, (FluidObject)TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL, folder);
        this.compatMeltingCasting(consumer, MaterialIds.dragonsteelFire, (FluidObject)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_FIRE, folder);
        this.compatMeltingCasting(consumer, MaterialIds.dragonsteelIce, (FluidObject)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_ICE, folder);
        this.compatMeltingCasting(consumer, MaterialIds.dragonsteelLightning, (FluidObject)TCIntegrationsItems.MOLTEN_DRAGONSTEEL_LIGHTNING, folder);
        this.compatMeltingCasting(consumer, MaterialIds.desh, (FluidObject)TCIntegrationsItems.MOLTEN_DESH, folder);
        this.compatMeltingCasting(consumer, MaterialIds.calorite, (FluidObject)TCIntegrationsItems.MOLTEN_CALORITE, folder);
        this.compatMeltingCasting(consumer, MaterialIds.ostrum, (FluidObject)TCIntegrationsItems.MOLTEN_OSTRUM, folder);
    }
}

