/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SpriteSourceProvider;
import slimeknights.tconstruct.library.client.modifiers.TrimModifierModel;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class TinkerSpriteSourceProvider
extends SpriteSourceProvider {
    private static final String[] TRIMS = new String[]{"coast", "sentry", "dune", "wild", "ward", "eye", "vex", "tide", "snout", "rib", "spire", "wayfinder", "shaper", "silence", "raiser", "host"};

    public TinkerSpriteSourceProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, fileHelper, "tconstruct");
    }

    protected void addSources() {
        String paletteFolder = "trims/color_palettes/";
        String trimFolder = "trims/models/armor/";
        ResourceLocation trimPalette = new ResourceLocation(paletteFolder + "trim_palette");
        Map<String, ResourceLocation> materialMap = Arrays.stream(MaterialIds.TRIM_MATERIALS).collect(Collectors.toMap(id -> id.m_135827_() + "_" + id.m_135815_(), id -> id.m_246208_(paletteFolder)));
        SpriteSourceProvider.SourceList blocks = this.atlas(BLOCKS_ATLAS).addSource((SpriteSource)TinkerSpriteSourceProvider.directory("fluid")).addSource((SpriteSource)TinkerSpriteSourceProvider.directory("gui/modifiers")).addSource((SpriteSource)TinkerSpriteSourceProvider.directory("gui/tinker_pattern")).addSource((SpriteSource)new PalettedPermutations(List.of(TrimModifierModel.TRIM_TEXTURES), trimPalette, materialMap));
        for (ResourceLocation name2 : TrimModifierModel.TRIM_TEXTURES) {
            blocks.addSource((SpriteSource)new SingleFile(name2, Optional.empty()));
        }
        this.atlas(new ResourceLocation("armor_trims")).addSource((SpriteSource)new PalettedPermutations(Arrays.stream(TRIMS).flatMap(name -> Stream.of(new ResourceLocation(trimFolder + name), new ResourceLocation(trimFolder + name + "_leggings"))).toList(), trimPalette, materialMap));
    }

    private static DirectoryLister directory(String path) {
        return new DirectoryLister(path, path + "/");
    }
}

