/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import slimeknights.tconstruct.fluids.item.ContainerFoodItem;

public class FoodCakeBlock
extends CakeBlock {
    private final FoodProperties food;
    private final EffectCombination combination;

    public FoodCakeBlock(BlockBehaviour.Properties properties, FoodProperties food, EffectCombination combination) {
        super(properties);
        this.food = food;
        this.combination = combination;
    }

    @Deprecated(forRemoval=true)
    public FoodCakeBlock(BlockBehaviour.Properties properties, FoodProperties food) {
        this(properties, food, EffectCombination.BLOCK);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> tooltip, TooltipFlag pFlag) {
        ContainerFoodItem.addEffectTooltip(this.food, tooltip);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult result = this.eatSlice((LevelAccessor)world, pos, state, player);
        if (result.m_19077_()) {
            return result;
        }
        if (world.m_5776_() && player.m_21120_(handIn).m_41619_()) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean hasAllEffects(Player player) {
        for (Pair pair : this.food.m_38749_()) {
            MobEffectInstance current;
            if (pair.getFirst() == null || (current = player.m_21124_(((MobEffectInstance)pair.getFirst()).m_19544_())) != null && current.m_19557_() >= 100) continue;
            return false;
        }
        return true;
    }

    private InteractionResult eatSlice(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false) && !this.food.m_38747_()) {
            return InteractionResult.PASS;
        }
        if (this.combination == EffectCombination.BLOCK && this.hasAllEffects(player)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(this.food.m_38744_(), this.food.m_38745_());
        for (Pair pair : this.food.m_38749_()) {
            MobEffectInstance current;
            if (world.m_5776_() || pair.getFirst() == null || !(world.m_213780_().m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
            MobEffectInstance effect = new MobEffectInstance((MobEffectInstance)pair.getFirst());
            if (this.combination == EffectCombination.ADD && (current = player.m_21124_(effect.m_19544_())) != null && current.m_19564_() == effect.m_19564_()) {
                effect.f_19503_ += current.m_19557_();
            }
            player.m_7292_(effect);
        }
        int i = (Integer)state.m_61143_((Property)f_51180_);
        if (i < 6) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.m_7471_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum EffectCombination {
        SET,
        ADD,
        BLOCK;

    }
}

