/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.tools.network.PushBlockRowPacket;

public record MoveBlocksFluidEffect(boolean push, SoundEvent sound) implements FluidEffect<FluidEffectContext.Block>
{
    public static final RecordLoadable<MoveBlocksFluidEffect> LOADER = RecordLoadable.create((RecordField)BooleanLoadable.INSTANCE.requiredField("push", MoveBlocksFluidEffect::push), (RecordField)Loadables.SOUND_EVENT.requiredField("sound", MoveBlocksFluidEffect::sound), MoveBlocksFluidEffect::new);

    public static MoveBlocksFluidEffect push(SoundEvent sound) {
        return new MoveBlocksFluidEffect(true, sound);
    }

    public static MoveBlocksFluidEffect pull(SoundEvent sound) {
        return new MoveBlocksFluidEffect(false, sound);
    }

    @Override
    public RecordLoadable<MoveBlocksFluidEffect> getLoader() {
        return LOADER;
    }

    private static void destroyBlock(Level level, BlockPos pos, BlockState state) {
        BlockEntity targetBE = state.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)targetBE);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
        level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
        if (!state.m_60713_(Blocks.f_50083_)) {
            level.m_142052_(pos, state);
        }
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        if (level.isFull()) {
            BlockState state;
            Direction facing;
            if (context.breakRestricted()) {
                return 0.0f;
            }
            BlockPos pos = context.getBlockPos();
            Level world = context.getLevel();
            BlockState originalState = world.m_8055_(pos);
            if (originalState.m_60795_()) {
                return 0.0f;
            }
            if (originalState.m_60811_() == PushReaction.DESTROY) {
                if (originalState.m_60734_() instanceof LiquidBlock) {
                    return 0.0f;
                }
                if (action.execute()) {
                    MoveBlocksFluidEffect.destroyBlock(world, pos, originalState);
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)originalState));
                    BlockState airState = Blocks.f_50016_.m_49966_();
                    originalState.m_60758_((LevelAccessor)world, pos, 2);
                    airState.m_60701_((LevelAccessor)world, pos, 2);
                    airState.m_60758_((LevelAccessor)world, pos, 2);
                }
                return 1.0f;
            }
            Direction direction = facing = context.getHitResult().m_82434_().m_122424_();
            if (!this.push) {
                direction = direction.m_122424_();
            }
            if (!PistonBaseBlock.m_60204_((BlockState)originalState, (Level)world, (BlockPos)pos, (Direction)direction, (boolean)false, (Direction)facing)) {
                return 0.0f;
            }
            int moving = 0;
            do {
                if (++moving > 12) {
                    return 0.0f;
                }
                BlockPos target = pos.m_5484_(direction, moving);
                state = world.m_8055_(target);
                if (PistonBaseBlock.m_60204_((BlockState)state, (Level)world, (BlockPos)target, (Direction)direction, (boolean)true, (Direction)facing)) continue;
                return 0.0f;
            } while (!state.m_60795_() && state.m_60811_() != PushReaction.DESTROY);
            if (action.execute()) {
                MoveBlocksFluidEffect.moveBlocks(world, pos, originalState, facing, direction, moving);
                TinkerNetwork.getInstance().sendToClientsAround(new PushBlockRowPacket(pos, direction, this.push, moving), (LevelAccessor)world, pos);
                world.m_5594_(null, pos, Sounds.SLIME_SLING.getSound(), SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * (this.push ? 0.25f : 0.15f) + 0.6f);
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public static void moveBlocks(Level world, BlockPos pos, BlockState originalState, Direction facing, Direction direction, int moving) {
        BlockPos[] targets = new BlockPos[moving + 1];
        for (int i = 0; i <= moving; ++i) {
            targets[i] = pos.m_5484_(direction, i);
        }
        BlockState removedState = world.m_8055_(targets[moving]);
        if (!removedState.m_60795_()) {
            MoveBlocksFluidEffect.destroyBlock(world, targets[moving], removedState);
        }
        Block[] blocksToUpdate = new Block[moving];
        for (int i = moving - 1; i >= 0; --i) {
            BlockState pushedState = world.m_8055_(targets[i]);
            blocksToUpdate[i] = pushedState.m_60734_();
            BlockState movingBlockState = (BlockState)Blocks.f_50110_.m_49966_().m_61124_((Property)MovingPistonBlock.f_60046_, (Comparable)facing);
            world.m_7731_(targets[i + 1], movingBlockState, 68);
            world.m_151523_(MovingPistonBlock.m_155881_((BlockPos)targets[i + 1], (BlockState)movingBlockState, (BlockState)pushedState, (Direction)facing, (facing == direction ? 1 : 0) != 0, (boolean)false));
        }
        BlockState airState = Blocks.f_50016_.m_49966_();
        world.m_7731_(pos, airState, 82);
        originalState.m_60758_((LevelAccessor)world, pos, 2);
        airState.m_60701_((LevelAccessor)world, pos, 2);
        airState.m_60758_((LevelAccessor)world, pos, 2);
        if (!removedState.m_60795_()) {
            removedState.m_60758_((LevelAccessor)world, targets[moving], 2);
            world.m_46672_(targets[moving], removedState.m_60734_());
        }
        for (int i = moving - 1; i >= 0; --i) {
            world.m_46672_(targets[i], blocksToUpdate[i]);
        }
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return Component.m_237115_((String)(FluidEffect.getTranslationKey(this.getLoader()) + (this.push ? ".push" : ".pull")));
    }
}

