/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public record PushEntityFluidEffect(LevelingValue value) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<PushEntityFluidEffect> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.directField(PushEntityFluidEffect::value), PushEntityFluidEffect::new);

    public PushEntityFluidEffect(float flat, float eachLevel) {
        this(new LevelingValue(flat, eachLevel));
    }

    @Override
    public RecordLoadable<? extends FluidEffect<FluidEffectContext.Entity>> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        LivingEntity holder;
        if (this.value.isFlat() && !level.isFull()) {
            return 0.0f;
        }
        Entity target = context.getTarget();
        Projectile projectile = context.getProjectile();
        Vec3 direction = projectile != null ? projectile.m_20184_() : ((holder = context.getEntity()) == target || holder == null ? target.m_20154_() : target.m_20182_().m_82546_(holder.m_20182_()));
        if ((direction = direction.m_82541_().m_82490_((double)this.value.compute(level.value()))).m_82556_() > 0.0) {
            if (action.execute()) {
                target.m_5997_(direction.f_82479_, direction.f_82480_, direction.f_82481_);
                LivingEntity livingEntity = context.getLivingTarget();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
            return this.value.isFlat() ? 1.0f : level.value();
        }
        return 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return Component.m_237115_((String)(FluidEffect.getTranslationKey(this.getLoader()) + (this.value.compute(1.0f) >= 0.0f ? ".push" : ".pull")));
    }
}

