/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.common.Sounds;

public class TeleportHelper {
    private static final Set<RelativeMovement> PACKET_FLAGS = ImmutableSet.of((Object)RelativeMovement.X, (Object)RelativeMovement.Y, (Object)RelativeMovement.Z);

    public static boolean randomNearbyTeleport(LivingEntity living, ITeleportEventFactory factory) {
        if (living.m_20193_().f_46443_) {
            return true;
        }
        double posX = living.m_20185_();
        double posY = living.m_20186_();
        double posZ = living.m_20189_();
        for (int i = 0; i < 16; ++i) {
            double x = posX + (living.m_217043_().m_188500_() - 0.5) * 16.0;
            double y = Mth.m_14008_((double)(posY + (double)(living.m_217043_().m_188503_(16) - 8)), (double)0.0, (double)(living.m_20193_().m_141928_() - 1));
            double z = posZ + (living.m_217043_().m_188500_() - 0.5) * 16.0;
            if (living.m_20159_()) {
                living.m_8127_();
            }
            EntityTeleportEvent event = factory.create(living, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled() || !living.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
            SoundEvent soundevent = Sounds.SLIME_TELEPORT.getSound();
            living.m_9236_().m_6263_(null, posX, posY, posZ, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
            living.m_5496_(soundevent, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private static void spawnParticles(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            for (int i = 0; i < 32; ++i) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + level.f_46441_.m_188500_() * 2.0, entity.m_20189_(), 1, level.f_46441_.m_188583_(), 0.0, level.f_46441_.m_188583_(), 0.0);
            }
        }
    }

    public static boolean tryTeleport(EntityTeleportEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            Entity entity = event.getEntity();
            TeleportHelper.spawnParticles(entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer playerMP = (ServerPlayer)entity;
                playerMP.f_8906_.m_9780_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), playerMP.m_146908_(), playerMP.m_146909_(), PACKET_FLAGS);
            } else {
                entity.m_6034_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            }
            TeleportHelper.spawnParticles(entity);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.ENDERPORTING.getSound(), entity.m_5720_(), 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ITeleportEventFactory {
        public EntityTeleportEvent create(LivingEntity var1, double var2, double var4, double var6);
    }
}

