/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.common.registration.AttributeDeferredRegister;

public class TinkerAttributes {
    private static final AttributeDeferredRegister ATTRIBUTES = new AttributeDeferredRegister("tconstruct");
    public static final RegistryObject<Attribute> BOUNCY = ATTRIBUTES.registerPercent("generic.bouncy", 0.0, true);
    public static final RegistryObject<Attribute> USE_ITEM_SPEED = ATTRIBUTES.registerPercent("player.use_item_speed", 0.2f, true);
    public static final RegistryObject<Attribute> PROTECTION_CAP = ATTRIBUTES.register("generic.protection_cap", 0.8, 0.0, 0.95f, true);
    public static final RegistryObject<Attribute> CRITICAL_DAMAGE = ATTRIBUTES.register("player.critical_damage", 1.5, 0.0, 100.0, false);
    public static final RegistryObject<Attribute> JUMP_BOOST = ATTRIBUTES.register("generic.jump_boost", 0.0, 0.0, 100.0, true);
    public static final RegistryObject<Attribute> SAFE_FALL_DISTANCE = ATTRIBUTES.register("generic.safe_fall_distance", 0.0, -10.0, 100.0, true);
    public static final RegistryObject<Attribute> JUMP_COUNT = ATTRIBUTES.register("player.jump_count", 1.0, 1.0, 100.0, true);
    public static final RegistryObject<Attribute> KNOCKBACK_MULTIPLIER = ATTRIBUTES.registerMultiplier("generic.knockback_multiplier", true);
    public static final RegistryObject<Attribute> MINING_SPEED_MULTIPLIER = ATTRIBUTES.registerMultiplier("player.mining_speed_multiplier", true);
    public static final RegistryObject<Attribute> EXPERIENCE_MULTIPLIER = ATTRIBUTES.registerMultiplier("player.experience_multiplier", false);
    public static final RegistryObject<Attribute> CROUCH_DAMAGE_MULTIPLIER = ATTRIBUTES.registerMultiplier("generic.crouch_damage_multiplier", false);
    public static final RegistryObject<Attribute> GOOD_EFFECT_DURATION = ATTRIBUTES.registerMultiplier("generic.good_effect_duration_multiplier", false);
    public static final RegistryObject<Attribute> BAD_EFFECT_DURATION = ATTRIBUTES.registerMultiplier("generic.bad_effect_duration_multiplier", false);

    public TinkerAttributes() {
        ATTRIBUTES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    void addAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)USE_ITEM_SPEED.get());
        event.add(EntityType.f_20532_, (Attribute)CRITICAL_DAMAGE.get());
        event.add(EntityType.f_20532_, (Attribute)MINING_SPEED_MULTIPLIER.get());
        event.add(EntityType.f_20532_, (Attribute)EXPERIENCE_MULTIPLIER.get());
        event.add(EntityType.f_20532_, (Attribute)JUMP_COUNT.get());
        TinkerAttributes.addToAll(event, BOUNCY);
        TinkerAttributes.addToAll(event, PROTECTION_CAP);
        TinkerAttributes.addToAll(event, JUMP_BOOST);
        TinkerAttributes.addToAll(event, SAFE_FALL_DISTANCE);
        TinkerAttributes.addToAll(event, CROUCH_DAMAGE_MULTIPLIER);
        TinkerAttributes.addToAll(event, KNOCKBACK_MULTIPLIER);
        TinkerAttributes.addToAll(event, GOOD_EFFECT_DURATION);
        TinkerAttributes.addToAll(event, BAD_EFFECT_DURATION);
    }

    private static void addToAll(EntityAttributeModificationEvent event, RegistryObject<Attribute> attribute, double defaultValue) {
        Attribute attr = (Attribute)attribute.get();
        for (EntityType entity : event.getTypes()) {
            event.add(entity, attr, defaultValue);
        }
    }

    private static void addToAll(EntityAttributeModificationEvent event, RegistryObject<Attribute> attribute) {
        TinkerAttributes.addToAll(event, attribute, ((Attribute)attribute.get()).m_22082_());
    }
}

