/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import slimeknights.tconstruct.common.TinkerTags;

public class PlatformBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[64];
    private static final BooleanProperty[] DIRECTIONS = new BooleanProperty[]{BlockStateProperties.f_61367_, BlockStateProperties.f_61366_, BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_};
    public static final BooleanProperty WATERLOGGED;

    private static int makeShapeIndex(boolean up, boolean down, boolean north, boolean east, boolean south, boolean west) {
        return (down ? 1 : 0) | (up ? 2 : 0) | (north ? 4 : 0) | (south ? 8 : 0) | (west ? 16 : 0) | (east ? 32 : 0);
    }

    public PlatformBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])DIRECTIONS);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[PlatformBlock.makeShapeIndex((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_), (Boolean)state.m_61143_((Property)BlockStateProperties.f_61367_), (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_), (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_), (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_), (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_))];
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    private static boolean facingConnected(Direction facing, BlockState state, DirectionProperty property) {
        return !state.m_61138_((Property)property) || state.m_61143_((Property)property) == facing;
    }

    private static boolean connected(Direction direction, BlockState state) {
        if (!state.m_204336_(TinkerTags.Blocks.PLATFORM_CONNECTIONS)) {
            return false;
        }
        BooleanProperty sideProp = DIRECTIONS[direction.m_122424_().m_122411_()];
        if (state.m_61138_((Property)sideProp)) {
            return (Boolean)state.m_61143_((Property)sideProp);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61376_) && state.m_61143_((Property)BlockStateProperties.f_61376_) != AttachFace.WALL) {
            return false;
        }
        return PlatformBlock.facingConnected(direction, state, BlockStateProperties.f_61374_) && PlatformBlock.facingConnected(direction, state, BlockStateProperties.f_61372_) && PlatformBlock.facingConnected(direction, state, BlockStateProperties.f_61373_);
    }

    protected boolean verticalConnect(BlockState state) {
        return state.m_60713_((Block)this);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(this.verticalConnect(level.m_8055_(pos.m_7494_()))))).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(this.verticalConnect(belowState) || belowState.m_60783_((BlockGetter)level, below, Direction.UP)));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            state = (BlockState)state.m_61124_((Property)DIRECTIONS[direction.m_122411_()], (Comparable)Boolean.valueOf(PlatformBlock.connected(direction, level.m_8055_(pos.m_121945_(direction)))));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos selfPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(selfPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == Direction.UP) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(this.verticalConnect(neighbor)));
        }
        if (direction == Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(this.verticalConnect(neighbor) || neighbor.m_60783_((BlockGetter)level, neighborPos, Direction.UP)));
        }
        return (BlockState)state.m_61124_((Property)DIRECTIONS[direction.m_122411_()], (Comparable)Boolean.valueOf(PlatformBlock.connected(direction, neighbor)));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    static {
        VoxelShape neither = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)});
        VoxelShape bottom = Shapes.m_83110_((VoxelShape)neither, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        VoxelShape topPlate = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape top = Shapes.m_83110_((VoxelShape)neither, (VoxelShape)topPlate);
        VoxelShape both = Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)topPlate);
        boolean[] bools = new boolean[]{false, true};
        VoxelShape northPlate = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0);
        VoxelShape southPlate = Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0, (double)16.0);
        VoxelShape westPlate = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0);
        VoxelShape eastPlate = Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        for (boolean north : bools) {
            for (boolean east : bools) {
                for (boolean south : bools) {
                    for (boolean west : bools) {
                        for (boolean up : bools) {
                            for (boolean down : bools) {
                                VoxelShape shape;
                                if (up) {
                                    shape = down ? neither : bottom;
                                } else {
                                    VoxelShape voxelShape = shape = down ? top : both;
                                }
                                if (north) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)northPlate, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (south) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)southPlate, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (west) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)westPlate, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (east) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)eastPlate, (BooleanOp)BooleanOp.f_82695_);
                                }
                                int index = PlatformBlock.makeShapeIndex(up, down, north, east, south, west);
                                PlatformBlock.SHAPES[index] = shape.m_83296_();
                            }
                        }
                    }
                }
            }
        }
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

