/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.tconstruct.library.client.TinkerRenderTypes;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;

public class SmelteryTankRenderer {
    private static final float FLUID_OFFSET = 0.005f;
    private static final int HEIGHT_OFFSET = 9;

    private static float[] getBlockBounds(int delta) {
        return SmelteryTankRenderer.getBlockBounds(delta, 0.005f, (float)delta + 1.0f - 0.005f);
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    public static void renderFluids(PoseStack matrices, MultiBufferSource buffer, SmelteryTank<?> tank, BlockPos tankMinPos, BlockPos tankMaxPos, int brightness) {
        List<FluidStack> fluids = tank.getFluids();
        if (!fluids.isEmpty()) {
            int xd = tankMaxPos.m_123341_() - tankMinPos.m_123341_();
            int zd = tankMaxPos.m_123343_() - tankMinPos.m_123343_();
            if (xd < 0 || zd < 0) {
                return;
            }
            float[] xBounds = SmelteryTankRenderer.getBlockBounds(xd);
            float[] zBounds = SmelteryTankRenderer.getBlockBounds(zd);
            int yd = 1 + Math.max(0, tankMaxPos.m_123342_() - tankMinPos.m_123342_());
            int[] heights = GuiSmelteryTank.calcLiquidHeights(fluids, tank.getCapacity(), yd * 1000 - 9, 100);
            VertexConsumer builder = buffer.m_6299_(TinkerRenderTypes.SMELTERY_FLUID);
            float curY = 0.005f;
            for (int i = 0; i < fluids.size(); ++i) {
                float h = (float)heights[i] / 1000.0f;
                SmelteryTankRenderer.renderLargeFluidCuboid(matrices, builder, fluids.get(i), brightness, xd, xBounds, zd, zBounds, curY, curY + h);
                curY += h;
            }
        }
    }

    private static void renderLargeFluidCuboid(PoseStack matrices, VertexConsumer builder, FluidStack fluid, int brightness, int xd, float[] xBounds, int zd, float[] zBounds, float yMin, float yMax) {
        if (yMin >= yMax || fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
        int color = attributes.getTintColor(fluid);
        FluidType fluidType = fluid.getFluid().getFluidType();
        brightness = FluidRenderer.withBlockLight((int)brightness, (int)fluidType.getLightLevel(fluid));
        boolean upsideDown = fluidType.isLighterThanAir();
        int yd = (int)(yMax - (float)((int)yMin));
        if ((double)yMax % 1.0 == 0.0) {
            --yd;
        }
        float[] yBounds = SmelteryTankRenderer.getBlockBounds(yd, yMin, yMax);
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        int rotation = upsideDown ? 180 : 0;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    from.set(xBounds[x], yBounds[y], zBounds[z]);
                    to.set(xBounds[x + 1], yBounds[y + 1], zBounds[z + 1]);
                    if (x == 0) {
                        FluidRenderer.putTexturedQuad((VertexConsumer)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.WEST, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (x == xd) {
                        FluidRenderer.putTexturedQuad((VertexConsumer)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.EAST, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (z == 0) {
                        FluidRenderer.putTexturedQuad((VertexConsumer)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.NORTH, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (z == zd) {
                        FluidRenderer.putTexturedQuad((VertexConsumer)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.SOUTH, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (y == yd) {
                        FluidRenderer.putTexturedQuad((VertexConsumer)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.UP, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (y != 0) continue;
                    from.y = from.y() + 0.001f;
                    FluidRenderer.putTexturedQuad((VertexConsumer)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.DOWN, (int)color, (int)brightness, (int)rotation, (boolean)false);
                }
            }
        }
    }
}

