/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.utils.Util;

@ApiStatus.Internal
public enum SmelteryCompat {
    TIN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTin, true),
    ALUMINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenAluminum, true),
    LEAD((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLead, true),
    SILVER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSilver, true),
    NICKEL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNickel, true),
    ZINC((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenZinc, true),
    PLATINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPlatinum, true),
    TUNGSTEN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTungsten, true),
    OSMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenOsmium, true),
    URANIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenUranium, true),
    BRONZE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBronze, "tin"),
    BRASS((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBrass, "zinc"),
    ELECTRUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenElectrum, "silver"),
    INVAR((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenInvar, "nickel"),
    CONSTANTAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenConstantan, "nickel"),
    PEWTER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPewter, "tin", "lead"),
    ENDERIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenEnderium, false),
    LUMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLumium, false),
    SIGNALUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSignalum, false),
    REFINED_GLOWSTONE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedGlowstone, false),
    REFINED_OBSIDIAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedObsidian, false),
    NICROSIL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNicrosil, false);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends ForgeFlowingFluid> fluid;
    private final boolean isOre;
    private final String[] tags;

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, boolean isOre) {
        this.fluid = fluid;
        this.isOre = isOre;
        this.tags = new String[]{this.name};
    }

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, String ... altTags) {
        this.fluid = fluid;
        this.isOre = false;
        this.tags = Util.append(altTags, this.name);
    }

    @Deprecated(forRemoval=true)
    public String getAltTag() {
        return this.tags.length < 2 ? "" : this.tags[0];
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOre() {
        return this.isOre;
    }

    public String[] getTags() {
        return this.tags;
    }
}

