/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.CreativeSlotModifier;

public class CreativeSlotItem
extends Item {
    private static final String NBT_KEY = "slot";
    private static final String TOOLTIP = TConstruct.makeTranslationKey("item", "creative_slot.tooltip");
    private static final Component TOOLTIP_MISSING = TConstruct.makeTranslation("item", "creative_slot.missing").m_130940_(ChatFormatting.RED);
    private static final Component CREATIVE_ONLY = TConstruct.makeTranslation("item", "creative_slot.only").m_130940_(ChatFormatting.RED);

    public CreativeSlotItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static SlotType getSlot(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_(NBT_KEY, 8)) {
            return SlotType.getIfPresent(nbt.m_128461_(NBT_KEY));
        }
        return null;
    }

    public static ItemStack withSlot(ItemStack stack, SlotType type) {
        stack.m_41784_().m_128359_(NBT_KEY, type.getName());
        return stack;
    }

    public String m_5671_(ItemStack stack) {
        String betterKey;
        SlotType slot = CreativeSlotItem.getSlot(stack);
        String originalKey = this.m_5524_();
        if (slot != null && Util.canTranslate(betterKey = originalKey + "." + slot.getName())) {
            return betterKey;
        }
        return originalKey;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        SlotType slot = CreativeSlotItem.getSlot(stack);
        if (slot != null) {
            tooltip.add((Component)Component.m_237110_((String)TOOLTIP, (Object[])new Object[]{slot.getDisplayName()}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(TOOLTIP_MISSING);
        }
    }

    public void addVariants(Consumer<ItemStack> items) {
        Collection<SlotType> allTypes = SlotType.getAllSlotTypes();
        if (allTypes.isEmpty()) {
            items.accept(new ItemStack((ItemLike)this));
        } else {
            for (SlotType type : allTypes) {
                items.accept(CreativeSlotItem.withSlot(new ItemStack((ItemLike)this), type));
            }
        }
    }

    public static boolean canApply(Player player) {
        return player.m_7500_() || (Boolean)Config.COMMON.quickApplyToolModifiersSurvival.get() != false && player.m_20310_(2);
    }

    private static boolean handleStackOn(ItemStack stack, ItemStack toolItem, Player player, int amount) {
        SlotType slotType = CreativeSlotItem.getSlot(stack);
        if (slotType != null && !toolItem.m_41619_() && toolItem.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            if (!player.m_9236_().f_46443_ || player.m_7500_() && player.f_36096_.f_38843_ == null) {
                if (CreativeSlotItem.canApply(player)) {
                    CompoundTag slots;
                    ToolStack tool = ToolStack.from(toolItem);
                    if (tool.getFreeSlots(slotType) + amount < 0) {
                        return true;
                    }
                    ToolDataNBT persistentData = tool.getPersistentData();
                    if (persistentData.contains(CreativeSlotModifier.KEY_SLOTS, 10)) {
                        slots = persistentData.getCompound(CreativeSlotModifier.KEY_SLOTS);
                    } else {
                        slots = new CompoundTag();
                        persistentData.put(CreativeSlotModifier.KEY_SLOTS, (Tag)slots);
                    }
                    String name = slotType.getName();
                    int updated = slots.m_128451_(name) + amount;
                    if (updated == 0) {
                        slots.m_128473_(name);
                    } else {
                        slots.m_128405_(name, updated);
                    }
                    ModifierId creative = TinkerModifiers.creativeSlot.getId();
                    int currentLevel = tool.getModifierLevel(creative);
                    if (slots.m_128456_()) {
                        persistentData.remove(CreativeSlotModifier.KEY_SLOTS);
                        tool.removeModifier(creative, currentLevel);
                    } else if (currentLevel == 0) {
                        tool.addModifier(creative, 1);
                    } else {
                        tool.rebuildStats();
                    }
                    player.m_5496_(amount > 0 ? SoundEvents.f_11887_ : SoundEvents.f_11998_, 1.0f, 0.8f + (float)stack.m_41613_() * 0.2f);
                } else if (!player.m_7500_()) {
                    player.m_5661_(CREATIVE_ONLY, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            return CreativeSlotItem.handleStackOn(stack, slot.m_7993_(), player, stack.m_41613_());
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack toolItem, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            return CreativeSlotItem.handleStackOn(stack, toolItem, player, -stack.m_41613_());
        }
        return false;
    }
}

