/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierBonusLootFunction
extends LootItemConditionalFunction {
    private final ModifierId modifier;
    private final ApplyBonusCount.Formula formula;
    private final boolean includeBase;

    protected ModifierBonusLootFunction(LootItemCondition[] conditions, ModifierId modifier, ApplyBonusCount.Formula formula, boolean includeBase) {
        super(conditions);
        this.modifier = modifier;
        this.formula = formula;
        this.includeBase = includeBase;
    }

    public static LootItemConditionalFunction.Builder<?> builder(ModifierId modifier, ApplyBonusCount.Formula formula, boolean includeBase) {
        return ModifierBonusLootFunction.m_80683_(conditions -> new ModifierBonusLootFunction((LootItemCondition[])conditions, modifier, formula, includeBase));
    }

    public static LootItemConditionalFunction.Builder<?> binomialWithBonusCount(ModifierId modifier, float probability, int extra, boolean includeBase) {
        return ModifierBonusLootFunction.builder(modifier, (ApplyBonusCount.Formula)new ApplyBonusCount.BinomialWithBonusCount(extra, probability), includeBase);
    }

    public static LootItemConditionalFunction.Builder<?> oreDrops(ModifierId modifier, boolean includeBase) {
        return ModifierBonusLootFunction.builder(modifier, (ApplyBonusCount.Formula)new ApplyBonusCount.OreDrops(), includeBase);
    }

    public static LootItemConditionalFunction.Builder<?> uniformBonusCount(ModifierId modifier, int bonusMultiplier, boolean includeBase) {
        return ModifierBonusLootFunction.builder(modifier, (ApplyBonusCount.Formula)new ApplyBonusCount.UniformBonusCount(bonusMultiplier), includeBase);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)TinkerModifiers.modifierBonusFunction.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81463_);
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        int level = ModifierUtil.getModifierLevel((ItemStack)context.m_165124_(LootContextParams.f_81463_), this.modifier);
        if (!this.includeBase) {
            --level;
        }
        if (level > 0) {
            stack.m_41764_(this.formula.m_213779_(context.m_230907_(), stack.m_41613_(), level));
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ModifierBonusLootFunction> {
        public void serialize(JsonObject json, ModifierBonusLootFunction loot, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)loot, context);
            json.addProperty("modifier", loot.modifier.toString());
            json.addProperty("formula", loot.formula.m_5713_().toString());
            JsonObject parameters = new JsonObject();
            loot.formula.m_6417_(parameters, context);
            if (parameters.size() > 0) {
                json.add("parameters", (JsonElement)parameters);
            }
            json.addProperty("include_base", Boolean.valueOf(loot.includeBase));
        }

        public ModifierBonusLootFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            ModifierId modifier = new ModifierId(JsonHelper.getResourceLocation((JsonObject)json, (String)"modifier"));
            ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"formula");
            ApplyBonusCount.FormulaDeserializer deserializer = (ApplyBonusCount.FormulaDeserializer)ApplyBonusCount.f_79898_.get(id);
            if (deserializer == null) {
                throw new JsonParseException("Invalid formula id: " + id);
            }
            JsonObject parameters = json.has("parameters") ? GsonHelper.m_13930_((JsonObject)json, (String)"parameters") : new JsonObject();
            ApplyBonusCount.Formula formula = deserializer.m_79970_(parameters, context);
            boolean includeBase = GsonHelper.m_13855_((JsonObject)json, (String)"include_base", (boolean)true);
            return new ModifierBonusLootFunction(conditions, modifier, formula, includeBase);
        }
    }
}

