/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import slimeknights.tconstruct.world.block.FoliageType;

public class SlimeColorizer {
    private static final Map<FoliageType, int[]> COLOR_MAP = (Map)Util.m_137469_(new EnumMap(FoliageType.class), map -> {
        for (FoliageType type : FoliageType.values()) {
            map.put(type, new int[65536]);
        }
    });
    public static final float LOOP = 256.0f;
    public static final BlockPos LOOP_OFFSET = BlockPos.m_274561_((double)128.0, (double)0.0, (double)128.0);

    public static void setGrassColor(FoliageType type, int[] colors) {
        COLOR_MAP.put(type, colors);
    }

    public static int getColor(FoliageType type, int x, int z) {
        return SlimeColorizer.getColor(COLOR_MAP.get((Object)type), x, z);
    }

    public static int getColorForPos(BlockPos pos, FoliageType type) {
        return SlimeColorizer.getColor(type, pos.m_123341_(), pos.m_123343_());
    }

    private static int getColor(int[] buffer, int posX, int posZ) {
        float z;
        float x = Math.abs((256.0f - (float)Math.abs(posX) % 512.0f) / 256.0f);
        if (x < (z = Math.abs((256.0f - (float)Math.abs(posZ) % 512.0f) / 256.0f))) {
            float tmp = x;
            x = z;
            z = tmp;
        }
        return buffer[(int)(x * 255.0f) << 8 | (int)(z * 255.0f)];
    }
}

