/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.block.connect;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.network.cable.IRefreshableCable;
import voltaic.common.block.connect.AbstractConnectBlock;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.prefab.tile.types.GenericConnectTile;
import voltaic.prefab.utilities.WorldUtils;

public abstract class AbstractRefreshingConnectBlock<CONDUCTOR extends GenericConnectTile>
extends AbstractConnectBlock {
    public AbstractRefreshingConnectBlock(BlockBehaviour.Properties properties, double radius) {
        super(properties, radius);
    }

    @Override
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        CONDUCTOR conductor = this.getCableIfValid(tile);
        if (conductor == null || conductor.m_58901_()) {
            return;
        }
        EnumConnectType[] connections = new EnumConnectType[6];
        for (Direction dir : Direction.values()) {
            BlockPos relPos = pos.m_121945_(dir);
            connections[dir.ordinal()] = this.getConnection(worldIn.m_8055_(relPos), worldIn.m_7702_(relPos), conductor, dir);
        }
        ((GenericConnectTile)conductor).writeConnections(Direction.values(), connections);
    }

    @Override
    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        EnumConnectType connection;
        super.onNeighborChange(state, world, pos, neighbor);
        if (world.m_5776_()) {
            return;
        }
        BlockEntity tile = world.m_7702_(pos);
        CONDUCTOR conductor = this.getCableIfValid(tile);
        if (conductor == null || conductor.m_58901_()) {
            return;
        }
        Direction facing = WorldUtils.getDirectionFromPosDelta(pos, neighbor);
        EnumConnectType currConnection = ((GenericConnectTile)conductor).readConnections()[facing.ordinal()];
        if (currConnection != (connection = this.getConnection(world.m_8055_(neighbor), world.m_7702_(neighbor), conductor, facing)) && ((GenericConnectTile)conductor).writeConnection(facing, connection)) {
            ((IRefreshableCable)conductor).updateNetwork(facing);
        }
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        EnumConnectType connection;
        if (world.m_5776_()) {
            return super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
        }
        BlockEntity tile = world.m_7702_(currentPos);
        CONDUCTOR conductor = this.getCableIfValid(tile);
        if (conductor == null || conductor.m_58901_()) {
            return super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
        }
        EnumConnectType currConnection = ((GenericConnectTile)conductor).readConnections()[facing.ordinal()];
        if (currConnection != (connection = this.getConnection(world.m_8055_(facingPos), world.m_7702_(facingPos), conductor, facing)) && ((GenericConnectTile)conductor).writeConnection(facing, connection)) {
            ((IRefreshableCable)conductor).updateNetwork(facing);
        }
        return super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
    }

    public abstract EnumConnectType getConnection(BlockState var1, BlockEntity var2, CONDUCTOR var3, Direction var4);

    @Nullable
    public abstract CONDUCTOR getCableIfValid(BlockEntity var1);
}

