/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.item.subtype;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.util.TriConsumer;
import voltaic.api.ISubtype;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.NBTUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;

public enum SubtypeItemUpgrade implements ISubtype
{
    basiccapacity(2, VoltaicTextUtils.tooltip("upgrade.basiccapacity", new Object[0]), "electrodynamics"),
    basicspeed(3, VoltaicTextUtils.tooltip("upgrade.basicspeed", new Object[0]), "electrodynamics", "assemblyline", "blastcraft"),
    advancedcapacity(4, VoltaicTextUtils.tooltip("upgrade.advancedcapacity", new Object[0]), "electrodynamics"),
    advancedspeed(3, VoltaicTextUtils.tooltip("upgrade.advancedspeed", new Object[0]), "electrodynamics", "assemblyline", "blastcraft"),
    iteminput((TriConsumer<GenericTile, ItemStack, Integer>)((TriConsumer)(holder, upgrade, procNumber) -> {
        ComponentInventory inv = (ComponentInventory)holder.getComponent(IComponentType.Inventory);
        if (!inv.hasInputRoom()) {
            return;
        }
        CompoundTag tag = upgrade.m_41784_();
        int tickNumber = tag.m_128451_("timer");
        if (tickNumber < 4) {
            tag.m_128405_("timer", tag.m_128451_("timer") + 1);
            return;
        }
        tag.m_128405_("timer", 0);
        List<Direction> dirs = NBTUtils.readDirectionList(upgrade);
        if (dirs.size() == 0) {
            return;
        }
        if (tag.m_128471_("smart")) {
            int index = 0;
            Direction dir = Direction.DOWN;
            for (int slot : inv.getInputSlotsForProcessor((int)procNumber)) {
                if (index < dirs.size()) {
                    dir = dirs.get(index);
                }
                SubtypeItemUpgrade.inputSmartMode(SubtypeItemUpgrade.getBlockEntity(holder, dir), inv, slot, procNumber, dir);
                ++index;
            }
        } else {
            for (Direction dir : dirs) {
                SubtypeItemUpgrade.inputDefaultMode(SubtypeItemUpgrade.getBlockEntity(holder, dir), inv, dir, procNumber);
            }
        }
    }), 1, VoltaicTextUtils.tooltip("upgrade.iteminput", new Object[0]), "electrodynamics", "assemblyline", "blastcraft"),
    itemoutput((TriConsumer<GenericTile, ItemStack, Integer>)((TriConsumer)(holder, upgrade, index) -> {
        ComponentInventory inv = (ComponentInventory)holder.getComponent(IComponentType.Inventory);
        if (!inv.hasItemsInOutput()) {
            return;
        }
        CompoundTag tag = upgrade.m_41784_();
        int tickNumber = tag.m_128451_("timer");
        if (tickNumber < 4) {
            tag.m_128405_("timer", tag.m_128451_("timer") + 1);
            return;
        }
        tag.m_128405_("timer", 0);
        List<Direction> dirs = NBTUtils.readDirectionList(upgrade);
        if (dirs.size() <= 0) {
            return;
        }
        if (tag.m_128471_("smart")) {
            int i;
            int size = 0;
            Direction dir = Direction.DOWN;
            for (i = 0; i < inv.outputs(); ++i) {
                if (size < dirs.size()) {
                    dir = dirs.get(size);
                }
                SubtypeItemUpgrade.outputSmartMode(SubtypeItemUpgrade.getBlockEntity(holder, dir), inv, i + inv.getOutputStartIndex(), dir);
                ++size;
            }
            for (i = 0; i < inv.biproducts(); ++i) {
                if (size < dirs.size()) {
                    dir = dirs.get(size);
                }
                SubtypeItemUpgrade.outputSmartMode(SubtypeItemUpgrade.getBlockEntity(holder, dir), inv, i + inv.getItemBiproductStartIndex(), dir);
                ++size;
            }
        } else {
            for (Direction dir : dirs) {
                SubtypeItemUpgrade.outputDefaultMode(SubtypeItemUpgrade.getBlockEntity(holder, dir), inv, dir);
            }
        }
    }), 1, VoltaicTextUtils.tooltip("upgrade.itemoutput", new Object[0]), "electrodynamics", "assemblyline", "blastcraft"),
    improvedsolarcell(1, VoltaicTextUtils.tooltip("upgrade.improvedsolarcell", new Object[0]), "electrodynamics"),
    stator(1, VoltaicTextUtils.tooltip("upgrade.stator", new Object[0]), "electrodynamics"),
    range(12, VoltaicTextUtils.tooltip("upgrade.range", new Object[0]), "electrodynamics", "assemblyline", "ballistix"),
    experience(1, VoltaicTextUtils.tooltip("upgrade.experience", new Object[0]), "electrodynamics", "assemblyline", "blastcraft"),
    itemvoid(1, VoltaicTextUtils.tooltip("upgrade.itemvoid", new Object[0]), "electrodynamics"),
    silktouch(1, VoltaicTextUtils.tooltip("upgrade.silktouch", new Object[0]), "electrodynamics"),
    fortune(3, VoltaicTextUtils.tooltip("upgrade.fortune", new Object[0]), "electrodynamics"),
    unbreaking(3, VoltaicTextUtils.tooltip("upgrade.unbreaking", new Object[0]), "electrodynamics");

    public final TriConsumer<GenericTile, ItemStack, Integer> applyUpgrade;
    public final int maxSize;
    public final boolean isEmpty;
    public final MutableComponent name;
    public final String[] modIds;

    private SubtypeItemUpgrade(TriConsumer<GenericTile, ItemStack, Integer> applyUpgrade, int maxSize, MutableComponent name, String ... modIds) {
        this.applyUpgrade = applyUpgrade;
        this.maxSize = maxSize;
        this.isEmpty = false;
        this.name = name;
        this.modIds = modIds;
    }

    private SubtypeItemUpgrade(int maxStackSize, MutableComponent name, String ... modIds) {
        this.applyUpgrade = (holder, upgrade, index) -> {};
        this.maxSize = maxStackSize;
        this.isEmpty = true;
        this.name = name;
        this.modIds = modIds;
    }

    @Override
    public String tag() {
        return "upgrade" + this.name();
    }

    @Override
    public String forgeTag() {
        return "upgrade/" + this.name();
    }

    @Override
    public boolean isItem() {
        return true;
    }

    private static void inputSmartMode(BlockEntity entity, ComponentInventory inv, int slot, int procNumber, Direction dir) {
        if (entity == null) {
            return;
        }
        IItemHandler item = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
        if (item == CapabilityUtils.EMPTY_ITEM_HANDLER) {
            return;
        }
        SubtypeItemUpgrade.removeItemFromHandler(item, inv, slot);
    }

    private static void inputDefaultMode(BlockEntity entity, ComponentInventory inv, Direction dir, int procNumber) {
        if (entity == null) {
            return;
        }
        IItemHandler item = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
        if (item == CapabilityUtils.EMPTY_ITEM_HANDLER) {
            return;
        }
        for (int slot : inv.getInputSlotsForProcessor(procNumber)) {
            SubtypeItemUpgrade.removeItemFromHandler(item, inv, slot);
        }
    }

    public static void removeItemFromHandler(IItemHandler handler, ComponentInventory inv, int slot) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack slotItem = inv.m_8020_(slot);
            boolean canPlace = inv.m_7013_(i, stack);
            if (slotItem.m_41619_() && canPlace) {
                int taken = stack.m_41613_() < inv.m_6893_() ? stack.m_41613_() : inv.m_6893_();
                ItemStack removed = handler.extractItem(i, taken, false);
                inv.m_6836_(slot, removed.m_41777_());
                inv.setChanged(slot);
                continue;
            }
            if (!ItemUtils.testItems(stack.m_41720_(), slotItem.m_41720_()) || !canPlace) continue;
            int cap = slotItem.m_41741_() < inv.m_6893_() ? slotItem.m_41741_() : inv.m_6893_();
            int canTake = cap - slotItem.m_41613_();
            inv.m_8020_(slot).m_41769_(handler.extractItem(i, canTake, false).m_41613_());
            inv.setChanged(slot);
        }
    }

    private static void outputSmartMode(BlockEntity entity, ComponentInventory inv, int index, Direction dir) {
        if (entity == null) {
            return;
        }
        IItemHandler item = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
        if (item == CapabilityUtils.EMPTY_ITEM_HANDLER) {
            return;
        }
        SubtypeItemUpgrade.addItemToHandler(item, inv, index);
    }

    private static void outputDefaultMode(BlockEntity entity, ComponentInventory inv, Direction dir) {
        int i;
        if (entity == null) {
            return;
        }
        IItemHandler item = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
        if (item == CapabilityUtils.EMPTY_ITEM_HANDLER) {
            return;
        }
        for (i = 0; i < inv.outputs(); ++i) {
            SubtypeItemUpgrade.addItemToHandler(item, inv, i + inv.getOutputStartIndex());
        }
        for (i = 0; i < inv.biproducts(); ++i) {
            SubtypeItemUpgrade.addItemToHandler(item, inv, i + inv.getItemBiproductStartIndex());
        }
    }

    private static void addItemToHandler(IItemHandler handler, ComponentInventory inv, int index) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack used = handler.insertItem(i, inv.m_8020_(index), false);
            inv.m_6836_(index, used);
            inv.setChanged(index);
            if (used.m_41619_()) break;
        }
    }

    @Nullable
    private static BlockEntity getBlockEntity(GenericTile holder, Direction dir) {
        BlockPos pos = holder.m_58899_().m_121945_(dir);
        BlockState state = holder.m_58904_().m_8055_(pos);
        if (state.m_155947_()) {
            return holder.m_58904_().m_7702_(holder.m_58899_().m_121945_(dir));
        }
        return null;
    }
}

