/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.packet.types.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;
import voltaic.common.packet.types.server.ServerBarrierMethods;

public class PacketUpdateCarriedItemServer {
    public static final StreamCodec<FriendlyByteBuf, PacketUpdateCarriedItemServer> CODEC = new StreamCodec<FriendlyByteBuf, PacketUpdateCarriedItemServer>(){

        @Override
        public void encode(FriendlyByteBuf buffer, PacketUpdateCarriedItemServer value) {
            StreamCodec.ITEM_STACK.encode(buffer, value.carriedItem);
            StreamCodec.BLOCK_POS.encode((ByteBuf)buffer, value.tilePos);
            StreamCodec.UUID.encode((ByteBuf)buffer, value.playerId);
        }

        @Override
        public PacketUpdateCarriedItemServer decode(FriendlyByteBuf buffer) {
            return new PacketUpdateCarriedItemServer(StreamCodec.ITEM_STACK.decode(buffer), StreamCodec.BLOCK_POS.decode((ByteBuf)buffer), StreamCodec.UUID.decode((ByteBuf)buffer));
        }
    };
    private final ItemStack carriedItem;
    private final BlockPos tilePos;
    private final UUID playerId;

    public PacketUpdateCarriedItemServer(ItemStack carriedItem, BlockPos tilePos, UUID playerId) {
        this.carriedItem = carriedItem;
        this.tilePos = tilePos;
        this.playerId = playerId;
    }

    public static void handle(PacketUpdateCarriedItemServer message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ServerBarrierMethods.handleUpdateCarriedItemServer(((NetworkEvent.Context)context.get()).getSender().m_9236_(), message.carriedItem, message.tilePos, message.playerId));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketUpdateCarriedItemServer message, FriendlyByteBuf buf) {
        CODEC.encode(buf, message);
    }

    public static PacketUpdateCarriedItemServer decode(FriendlyByteBuf buf) {
        return CODEC.decode(buf);
    }
}

