/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.item2fluid;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import voltaic.common.recipe.recipeutils.AbstractMaterialRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentProcessor;

public abstract class Item2FluidRecipe
extends AbstractMaterialRecipe {
    private List<CountableIngredient> inputItems;
    private FluidStack outputFluid;

    public Item2FluidRecipe(ResourceLocation group, List<CountableIngredient> itemInputs, FluidStack fluidOutput, double experience, int ticks, double usagePerTick, List<ProbableItem> itemBiproducts, List<ProbableFluid> fluidBiproducts, List<ProbableGas> gasBiproducts) {
        super(group, experience, ticks, usagePerTick, itemBiproducts, fluidBiproducts, gasBiproducts);
        this.inputItems = itemInputs;
        this.outputFluid = fluidOutput;
    }

    @Override
    public boolean matchesRecipe(ComponentProcessor pr, int procNumber) {
        Pair<List<Integer>, Boolean> pair = Item2FluidRecipe.areItemsValid(this.getCountedIngredients(), ((ComponentInventory)pr.getHolder().getComponent(IComponentType.Inventory)).getInputsForProcessor(procNumber));
        if (((Boolean)pair.getSecond()).booleanValue()) {
            this.setItemArrangement(procNumber, (List)pair.getFirst());
            return true;
        }
        return false;
    }

    @Override
    public FluidStack getFluidRecipeOutput() {
        return this.outputFluid;
    }

    public List<CountableIngredient> getCountedIngredients() {
        ArrayList<CountableIngredient> list = new ArrayList<CountableIngredient>();
        for (CountableIngredient ing : this.inputItems) {
            list.add(ing);
        }
        return list;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return new ArrayList<FluidIngredient>();
    }

    public static interface Factory<T extends Item2FluidRecipe> {
        public T create(ResourceLocation var1, List<CountableIngredient> var2, FluidStack var3, double var4, int var6, double var7, List<ProbableItem> var9, List<ProbableFluid> var10, List<ProbableGas> var11);
    }
}

