/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.item2fluid;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.codec.StreamCodec;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.VoltaicRecipeSerializer;
import voltaic.common.recipe.categories.item2fluid.Item2FluidRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.utilities.CodecUtils;

public class Item2FluidRecipeSerializer<T extends Item2FluidRecipe>
extends VoltaicRecipeSerializer<T> {
    private final Item2FluidRecipe.Factory<T> factory;

    public Item2FluidRecipeSerializer(Item2FluidRecipe.Factory<T> factory) {
        super(CodecUtils.composite(StreamCodec.RESOURCE_LOCATION, VoltaicRecipe::m_6423_, CountableIngredient.LIST_STREAM_CODEC, Item2FluidRecipe::getCountedIngredients, StreamCodec.FLUID_STACK, Item2FluidRecipe::getFluidRecipeOutput, StreamCodec.DOUBLE, VoltaicRecipe::getXp, StreamCodec.INT, VoltaicRecipe::getTicks, StreamCodec.DOUBLE, VoltaicRecipe::getUsagePerTick, ProbableItem.LIST_STREAM_CODEC, VoltaicRecipe::getItemBiproducts, ProbableFluid.LIST_STREAM_CODEC, VoltaicRecipe::getFluidBiproducts, ProbableGas.LIST_STREAM_CODEC, VoltaicRecipe::getGasBiproducts, factory::create));
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject recipeJson) {
        List<CountableIngredient> inputs = Item2FluidRecipeSerializer.getItemIngredients(recipeId, recipeJson);
        FluidStack output = Item2FluidRecipeSerializer.getFluidOutput(recipeId, recipeJson);
        double experience = Item2FluidRecipeSerializer.getExperience(recipeJson);
        int ticks = Item2FluidRecipeSerializer.getTicks(recipeId, recipeJson);
        double usagePerTick = Item2FluidRecipeSerializer.getUsagePerTick(recipeId, recipeJson);
        List<ProbableItem> itemBi = Item2FluidRecipeSerializer.getItemBiproducts(recipeId, recipeJson);
        List<ProbableFluid> fluidBi = Item2FluidRecipeSerializer.getFluidBiproducts(recipeId, recipeJson);
        List<ProbableGas> gasBi = Item2FluidRecipeSerializer.getGasBiproducts(recipeId, recipeJson);
        return this.factory.create(recipeId, inputs, output, experience, ticks, usagePerTick, itemBi, fluidBi, gasBi);
    }
}

