/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.recipecategories;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.gas.GasStack;
import voltaic.api.screen.ITexture;
import voltaic.compatibility.jei.utils.gui.ScreenObject;
import voltaic.compatibility.jei.utils.gui.types.ArrowAnimatedObject;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.compatibility.jei.utils.gui.types.ItemSlotObject;
import voltaic.compatibility.jei.utils.gui.types.fluidgauge.AbstractFluidGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.gasgauge.AbstractGasGaugeObject;
import voltaic.compatibility.jei.utils.ingredients.IngredientRendererGasStack;
import voltaic.compatibility.jei.utils.ingredients.VoltaicJeiTypes;
import voltaic.compatibility.jei.utils.label.AbstractLabelWrapper;
import voltaic.prefab.utilities.math.MathUtils;

public abstract class AbstractRecipeCategory<T>
implements IRecipeCategory<T> {
    protected int animationTime;
    protected Component title;
    protected IDrawable background;
    protected IDrawable icon;
    protected RecipeType<T> recipeType;
    public AbstractLabelWrapper[] labels = new AbstractLabelWrapper[0];
    protected ArrayList<AnimatedWrapper> animatedDrawables = new ArrayList();
    protected ArrayList<StaticWrapper> staticDrawables = new ArrayList();
    protected SlotDataWrapper[] inputSlotWrappers = new SlotDataWrapper[0];
    protected SlotDataWrapper[] outputSlotWrappers = new SlotDataWrapper[0];
    protected AbstractFluidGaugeObject[] fluidInputWrappers = new AbstractFluidGaugeObject[0];
    protected AbstractFluidGaugeObject[] fluidOutputWrappers = new AbstractFluidGaugeObject[0];
    protected AbstractGasGaugeObject[] gasInputWrappers = new AbstractGasGaugeObject[0];
    protected AbstractGasGaugeObject[] gasOutputWrappers = new AbstractGasGaugeObject[0];

    public AbstractRecipeCategory(IGuiHelper guiHelper, Component title, ItemStack inputMachine, BackgroundObject wrapper, RecipeType<T> recipeType, int animationTime) {
        this.title = title;
        this.recipeType = recipeType;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)inputMachine);
        ITexture texture = wrapper.getTexture();
        this.background = guiHelper.drawableBuilder(texture.getLocation(), wrapper.getX(), wrapper.getY(), wrapper.getWidth(), wrapper.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build();
        this.animationTime = animationTime;
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.drawnBackground(recipe, recipeSlotsView, graphics);
        this.drawPre(graphics, recipe);
        this.drawStatic(graphics);
        this.drawAnimated(graphics);
        this.drawPost(graphics, recipe);
        this.preLabels(graphics, recipe);
        this.addLabels(graphics, recipe);
        this.postLabels(graphics, recipe);
    }

    public void drawnBackground(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics) {
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        this.setItemInputs(this.getItemInputs(recipe), builder);
        this.setFluidInputs(this.getFluidInputs(recipe), builder);
        this.setItemOutputs(this.getItemOutputs(recipe), builder);
        this.setFluidOutputs(this.getFluidOutputs(recipe), builder);
        this.setGasInputs(this.getGasInputs(recipe), builder);
        this.setGasOutputs(this.getGasOutputs(recipe), builder);
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public void setLabels(AbstractLabelWrapper ... labels) {
        this.labels = labels;
    }

    public void setInputSlots(IGuiHelper guiHelper, ItemSlotObject ... inputSlots) {
        this.inputSlotWrappers = new SlotDataWrapper[inputSlots.length];
        for (int i = 0; i < inputSlots.length; ++i) {
            ItemSlotObject slot = inputSlots[i];
            this.inputSlotWrappers[i] = new SlotDataWrapper(slot.getItemXStart(), slot.getItemYStart(), slot.getRole());
            ITexture texture = slot.getTexture();
            this.staticDrawables.add(new StaticWrapper(slot.getX(), slot.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), slot.getWidth(), slot.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
            if (slot.getIcon() == null) continue;
            ScreenObject icon = slot.getIcon();
            texture = icon.getTexture();
            this.staticDrawables.add(new StaticWrapper(icon.getX(), icon.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), icon.getWidth(), icon.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setOutputSlots(IGuiHelper guiHelper, ItemSlotObject ... outputSlots) {
        this.outputSlotWrappers = new SlotDataWrapper[outputSlots.length];
        for (int i = 0; i < outputSlots.length; ++i) {
            ItemSlotObject slot = outputSlots[i];
            this.outputSlotWrappers[i] = new SlotDataWrapper(slot.getItemXStart(), slot.getItemYStart(), slot.getRole());
            ITexture texture = slot.getTexture();
            this.staticDrawables.add(new StaticWrapper(slot.getX(), slot.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), slot.getWidth(), slot.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
            if (slot.getIcon() == null) continue;
            ScreenObject icon = slot.getIcon();
            texture = icon.getTexture();
            this.staticDrawables.add(new StaticWrapper(icon.getX(), icon.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), icon.getWidth(), icon.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setFluidInputs(IGuiHelper guiHelper, AbstractFluidGaugeObject ... gauges) {
        for (AbstractFluidGaugeObject gauge : this.fluidInputWrappers = gauges) {
            ITexture texture = gauge.getTexture();
            this.staticDrawables.add(new StaticWrapper(gauge.getX(), gauge.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), gauge.getWidth(), gauge.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setFluidOutputs(IGuiHelper guiHelper, AbstractFluidGaugeObject ... gauges) {
        for (AbstractFluidGaugeObject gauge : this.fluidOutputWrappers = gauges) {
            ITexture texture = gauge.getTexture();
            this.staticDrawables.add(new StaticWrapper(gauge.getX(), gauge.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), gauge.getWidth(), gauge.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setGasInputs(IGuiHelper guiHelper, AbstractGasGaugeObject ... gauges) {
        for (AbstractGasGaugeObject gauge : this.gasInputWrappers = gauges) {
            ITexture texture = gauge.getTexture();
            this.staticDrawables.add(new StaticWrapper(gauge.getX(), gauge.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), gauge.getWidth(), gauge.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setGasOutputs(IGuiHelper guiHelper, AbstractGasGaugeObject ... gauges) {
        for (AbstractGasGaugeObject gauge : this.gasOutputWrappers = gauges) {
            ITexture texture = gauge.getTexture();
            this.staticDrawables.add(new StaticWrapper(gauge.getX(), gauge.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), gauge.getWidth(), gauge.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setScreenObjects(IGuiHelper guiHelper, ScreenObject ... objects) {
        for (ScreenObject object : objects) {
            ITexture texture = object.getTexture();
            this.staticDrawables.add(new StaticWrapper(object.getX(), object.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), object.getWidth(), object.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setAnimatedArrows(IGuiHelper guiHelper, ArrowAnimatedObject ... arrows) {
        for (ArrowAnimatedObject arrow : arrows) {
            ITexture texture = arrow.getTexture();
            this.animatedDrawables.add(new AnimatedWrapper(arrow.getX(), arrow.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), arrow.getWidth(), arrow.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).buildAnimated(this.getAnimationTime(), arrow.startDirection(), false)));
            ScreenObject staticArrow = arrow.getOffArrow();
            texture = staticArrow.getTexture();
            this.staticDrawables.add(new StaticWrapper(staticArrow.getX(), staticArrow.getY(), guiHelper.drawableBuilder(texture.getLocation(), texture.textureU(), texture.textureV(), staticArrow.getWidth(), staticArrow.getHeight()).setTextureSize(texture.imageWidth(), texture.imageHeight()).build()));
        }
    }

    public void setItemInputs(List<List<ItemStack>> inputs, IRecipeLayoutBuilder builder) {
        for (int i = 0; i < this.inputSlotWrappers.length; ++i) {
            SlotDataWrapper wrapper = this.inputSlotWrappers[i];
            builder.addSlot(wrapper.role(), wrapper.x(), wrapper.y()).addItemStacks(inputs.get(i));
        }
    }

    public void setItemOutputs(List<ItemStack> outputs, IRecipeLayoutBuilder builder) {
        for (int i = 0; i < this.outputSlotWrappers.length; ++i) {
            SlotDataWrapper wrapper = this.outputSlotWrappers[i];
            if (i >= outputs.size()) continue;
            builder.addSlot(wrapper.role(), wrapper.x(), wrapper.y()).addItemStack(outputs.get(i));
        }
    }

    public void setFluidInputs(List<List<FluidStack>> inputs, IRecipeLayoutBuilder builder) {
        FluidStack stack;
        RecipeIngredientRole role = RecipeIngredientRole.INPUT;
        int maxGaugeCap = 0;
        for (List<FluidStack> stacks : inputs) {
            stack = stacks.get(0);
            int gaugeCap = (int)Math.pow(10.0, MathUtils.nearestPowerOf10(stack.getAmount(), true));
            if (gaugeCap <= maxGaugeCap) continue;
            maxGaugeCap = gaugeCap;
        }
        for (int i = 0; i < this.fluidInputWrappers.length; ++i) {
            AbstractFluidGaugeObject wrapper = this.fluidInputWrappers[i];
            stack = inputs.get(i).get(0);
            int amt = stack.getAmount();
            int height = (int)Math.ceil((float)amt / (float)maxGaugeCap * (float)wrapper.getFluidTextHeight());
            builder.addSlot(role, wrapper.getFluidXPos(), wrapper.getFluidYPos() - height).setFluidRenderer((long)stack.getAmount(), false, wrapper.getFluidTextWidth(), height).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs.get(i));
        }
    }

    public void setFluidOutputs(List<FluidStack> outputs, IRecipeLayoutBuilder builder) {
        RecipeIngredientRole role = RecipeIngredientRole.OUTPUT;
        int maxGaugeCap = 0;
        for (FluidStack s : outputs) {
            int gaugeCap = (int)Math.pow(10.0, MathUtils.nearestPowerOf10(s.getAmount(), true));
            if (gaugeCap <= maxGaugeCap) continue;
            maxGaugeCap = gaugeCap;
        }
        for (int i = 0; i < this.fluidOutputWrappers.length; ++i) {
            AbstractFluidGaugeObject wrapper = this.fluidOutputWrappers[i];
            FluidStack stack = outputs.get(i);
            int amt = stack.getAmount();
            int height = (int)Math.ceil((float)amt / (float)maxGaugeCap * (float)wrapper.getFluidTextHeight());
            builder.addSlot(role, wrapper.getFluidXPos(), wrapper.getFluidYPos() - height).setFluidRenderer((long)stack.getAmount(), false, wrapper.getFluidTextWidth(), height).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)stack);
        }
    }

    public void setGasInputs(List<List<GasStack>> inputs, IRecipeLayoutBuilder builder) {
        RecipeIngredientRole role = RecipeIngredientRole.INPUT;
        int maxGaugeCap = 0;
        for (List<GasStack> stackz : inputs) {
            GasStack stack = stackz.get(0);
            int gaugeCap = (int)Math.pow(10.0, MathUtils.nearestPowerOf10(stack.getAmount(), true));
            if (gaugeCap <= maxGaugeCap) continue;
            maxGaugeCap = gaugeCap;
        }
        for (int i = 0; i < this.gasInputWrappers.length; ++i) {
            AbstractGasGaugeObject wrapper = this.gasInputWrappers[i];
            List<GasStack> stacks = inputs.get(i);
            double amt = stacks.get(0).getAmount();
            int height = (int)Math.ceil(amt / (double)maxGaugeCap * (double)(wrapper.getHeight() - 2));
            int oneMinusHeight = wrapper.getHeight() - height;
            ((IRecipeSlotBuilder)builder.addSlot(role, wrapper.getX() + 1, wrapper.getY() + wrapper.getHeight() - height).addIngredients(VoltaicJeiTypes.GAS_STACK, stacks)).setCustomRenderer(VoltaicJeiTypes.GAS_STACK, (IIngredientRenderer)new IngredientRendererGasStack(maxGaugeCap, -oneMinusHeight + 1, height, wrapper.getBarsTexture()));
        }
    }

    public void setGasOutputs(List<GasStack> outputs, IRecipeLayoutBuilder builder) {
        RecipeIngredientRole role = RecipeIngredientRole.OUTPUT;
        int maxGaugeCap = 0;
        for (GasStack s : outputs) {
            int gaugeCap = (int)Math.pow(10.0, MathUtils.nearestPowerOf10(s.getAmount(), true));
            if (gaugeCap <= maxGaugeCap) continue;
            maxGaugeCap = gaugeCap;
        }
        for (int i = 0; i < this.gasOutputWrappers.length; ++i) {
            AbstractGasGaugeObject wrapper = this.gasOutputWrappers[i];
            GasStack stack = outputs.get(i);
            double amt = stack.getAmount();
            int height = (int)Math.ceil(amt / (double)maxGaugeCap * (double)(wrapper.getHeight() - 2));
            int oneMinusHeight = wrapper.getHeight() - height;
            ((IRecipeSlotBuilder)builder.addSlot(role, wrapper.getX() + 1, wrapper.getY() + wrapper.getHeight() - height).addIngredient(VoltaicJeiTypes.GAS_STACK, (Object)stack)).setCustomRenderer(VoltaicJeiTypes.GAS_STACK, (IIngredientRenderer)new IngredientRendererGasStack(maxGaugeCap, -oneMinusHeight + 1, height, wrapper.getBarsTexture()));
        }
    }

    public void drawStatic(GuiGraphics graphics) {
        for (StaticWrapper wrapper : this.staticDrawables) {
            wrapper.stat().draw(graphics, wrapper.x(), wrapper.y());
        }
    }

    public void drawAnimated(GuiGraphics graphics) {
        for (AnimatedWrapper wrapper : this.animatedDrawables) {
            wrapper.anim().draw(graphics, wrapper.x(), wrapper.y());
        }
    }

    public void drawPre(GuiGraphics graphics, T recipe) {
    }

    public void drawPost(GuiGraphics graphics, T recipe) {
    }

    public void addLabels(GuiGraphics graphics, T recipe) {
        Font font = Minecraft.m_91087_().f_91062_;
        for (AbstractLabelWrapper wrap : this.labels) {
            Component text = wrap.getComponent(this, recipe);
            if (wrap.xIsEnd()) {
                graphics.m_280614_(font, text, wrap.getXPos() - font.m_92724_(text.m_7532_()), wrap.getYPos(), wrap.getColor().color(), false);
                continue;
            }
            graphics.m_280614_(font, text, wrap.getXPos(), wrap.getYPos(), wrap.getColor().color(), false);
        }
    }

    public void preLabels(GuiGraphics graphics, T recipe) {
    }

    public void postLabels(GuiGraphics graphics, T recipe) {
    }

    public List<List<ItemStack>> getItemInputs(T recipe) {
        return new ArrayList<List<ItemStack>>();
    }

    public List<ItemStack> getItemOutputs(T recipe) {
        return new ArrayList<ItemStack>();
    }

    public List<List<FluidStack>> getFluidInputs(T recipe) {
        return new ArrayList<List<FluidStack>>();
    }

    public List<FluidStack> getFluidOutputs(T recipeo) {
        return new ArrayList<FluidStack>();
    }

    public List<List<GasStack>> getGasInputs(T recipe) {
        return new ArrayList<List<GasStack>>();
    }

    public List<GasStack> getGasOutputs(T recipe) {
        return new ArrayList<GasStack>();
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public record SlotDataWrapper(int x, int y, RecipeIngredientRole role) {
    }

    public record StaticWrapper(int x, int y, IDrawableStatic stat) {
    }

    public record AnimatedWrapper(int x, int y, IDrawableAnimated anim) {
    }
}

