/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.recipecategories.fluiditem2gas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.categories.fluiditem2gas.FluidItem2GasRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public abstract class FluidItem2GasRecipeCategory<T extends FluidItem2GasRecipe>
extends AbstractRecipeCategory<T> {
    public FluidItem2GasRecipeCategory(IGuiHelper guiHelper, Component title, ItemStack inputMachine, BackgroundObject wrapper, RecipeType<T> recipeType, int animationTime) {
        super(guiHelper, title, inputMachine, wrapper, recipeType, animationTime);
    }

    @Override
    public List<List<ItemStack>> getItemInputs(T recipe) {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        for (CountableIngredient countableIngredient : ((FluidItem2GasRecipe)recipe).getCountedIngredients()) {
            ingredients.add(Arrays.asList(countableIngredient.getItemsArray()));
        }
        for (FluidIngredient fluidIngredient : ((FluidItem2GasRecipe)recipe).getFluidIngredients()) {
            ArrayList<ItemStack> buckets = new ArrayList<ItemStack>();
            for (FluidStack stack : fluidIngredient.getMatchingFluids()) {
                ItemStack bucket = new ItemStack((ItemLike)stack.getFluid().m_6859_(), 1);
                IFluidHandlerItem handler = (IFluidHandlerItem)bucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
                if (handler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                    handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    bucket = handler.getContainer();
                }
                buckets.add(bucket);
            }
            ingredients.add(buckets);
        }
        return ingredients;
    }

    @Override
    public List<ItemStack> getItemOutputs(T recipe) {
        ItemStack bucket;
        IGasHandlerItem outputHandler;
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        if (((VoltaicRecipe)recipe).hasItemBiproducts()) {
            outputItems.addAll(Arrays.asList(((VoltaicRecipe)recipe).getFullItemBiStacks()));
        }
        if ((outputHandler = (IGasHandlerItem)(bucket = new ItemStack((ItemLike)((FluidItem2GasRecipe)recipe).getGasRecipeOutput().getGas().getContainer(), 1)).getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM)) != CapabilityUtils.EMPTY_GAS_ITEM) {
            outputHandler.fill(((FluidItem2GasRecipe)recipe).getGasRecipeOutput(), GasAction.EXECUTE);
            bucket = outputHandler.getContainer();
            outputItems.add(bucket);
        }
        if (((VoltaicRecipe)recipe).hasFluidBiproducts()) {
            for (ProbableFluid stack : ((VoltaicRecipe)recipe).getFluidBiproducts()) {
                ItemStack temp = new ItemStack((ItemLike)stack.getFullStack().getFluid().m_6859_(), 1);
                IFluidHandlerItem handler = (IFluidHandlerItem)temp.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
                if (handler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                    handler.fill(stack.getFullStack(), IFluidHandler.FluidAction.EXECUTE);
                    temp = handler.getContainer();
                }
                outputItems.add(temp);
            }
        }
        return outputItems;
    }

    @Override
    public List<List<FluidStack>> getFluidInputs(T recipe) {
        ArrayList<List<FluidStack>> ingredients = new ArrayList<List<FluidStack>>();
        for (FluidIngredient ing : ((FluidItem2GasRecipe)recipe).getFluidIngredients()) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (FluidStack stack : ing.getMatchingFluids()) {
                if (BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid()).toString().toLowerCase(Locale.ROOT).contains("flow")) continue;
                fluids.add(stack);
            }
            ingredients.add(fluids);
        }
        return ingredients;
    }

    @Override
    public List<GasStack> getGasOutputs(T recipe) {
        ArrayList<GasStack> outputFluids = new ArrayList<GasStack>();
        outputFluids.add(((FluidItem2GasRecipe)recipe).getGasRecipeOutput());
        if (((VoltaicRecipe)recipe).hasGasBiproducts()) {
            outputFluids.addAll(Arrays.asList(((VoltaicRecipe)recipe).getFullGasBiStacks()));
        }
        return outputFluids;
    }
}

