/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.client;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import voltaic.client.VoltaicClientRegister;

public abstract class BaseItemModelsProvider
extends ItemModelProvider {
    public final String modID;

    public BaseItemModelsProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modID) {
        super(output, modID, existingFileHelper);
        this.modID = modID;
    }

    public void layeredItem(RegistryObject<? extends Item> item, Parent parent, ResourceLocation ... textures) {
        this.layeredItem(this.name(item), parent, textures);
    }

    public void layeredItem(Item item, Parent parent, ResourceLocation ... textures) {
        this.layeredItem(this.name(item), parent, textures);
    }

    public void layeredItem(String name, Parent parent, ResourceLocation ... textures) {
        this.layeredBuilder(name, parent, textures);
    }

    public void toggleableItem(RegistryObject<? extends Item> item, String toggle, Parent parentOff, Parent parentOn, ResourceLocation[] offText, ResourceLocation[] onText) {
        this.toggleableItem(this.name(item), toggle, parentOff, parentOn, offText, onText);
    }

    public void toggleableItem(String name, String toggle, Parent parentOff, Parent parentOn, ResourceLocation[] offText, ResourceLocation[] onText) {
        ItemModelBuilder off = this.layeredBuilder(name, parentOff, offText);
        ItemModelBuilder on = this.layeredBuilder(name + toggle, parentOn, onText);
        off.override().predicate(VoltaicClientRegister.ON, 1.0f).model((ModelFile)on).end();
    }

    public ItemModelBuilder layeredBuilder(String name, Parent parent, ResourceLocation ... textures) {
        if (textures == null || textures.length == 0) {
            throw new UnsupportedOperationException("You need to provide at least one texture");
        }
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, parent.loc());
        int counter = 0;
        for (ResourceLocation location : textures) {
            builder.texture("layer" + counter, location);
            ++counter;
        }
        return builder;
    }

    public DynamicFluidContainerModelBuilder<ItemModelBuilder> getBucketModel(RegistryObject<? extends Item> item, Parent parent) {
        return this.getBucketModel(this.name(item), parent);
    }

    public DynamicFluidContainerModelBuilder<ItemModelBuilder> getBucketModel(String name, Parent parent) {
        return (DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(name, parent.loc)).customLoader(DynamicFluidContainerModelBuilder::begin);
    }

    public ItemModelBuilder simpleBlockItem(Block block, ModelFile model) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.key(block).m_135815_())).parent(model);
    }

    public ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    public ResourceLocation itemLoc(String texture) {
        return this.modLoc("item/" + texture);
    }

    public ResourceLocation blockLoc(String texture) {
        return this.modLoc("block/" + texture);
    }

    public String name(RegistryObject<? extends Item> item) {
        return this.name((Item)item.get());
    }

    public String name(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
    }

    public ModelFile.ExistingModelFile existingBlock(RegistryObject<? extends Block> block) {
        return this.existingBlock(block.getId());
    }

    public ModelFile.ExistingModelFile existingBlock(Block block) {
        return this.existingBlock(BuiltInRegistries.f_256975_.m_7981_((Object)block));
    }

    public ModelFile.ExistingModelFile existingBlock(ResourceLocation loc) {
        return this.getExistingFile(loc);
    }

    public static enum Parent {
        GENERATED,
        HANDHELD,
        FORGE_DEFAULT("forge", "item/default");

        @Nullable
        private final ResourceLocation loc;

        private Parent() {
            this.loc = null;
        }

        private Parent(String id, String loc) {
            this.loc = new ResourceLocation(id, loc);
        }

        public ResourceLocation loc() {
            return this.loc == null ? new ResourceLocation(this.toString().toLowerCase(Locale.ROOT)) : this.loc;
        }
    }
}

