/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.client;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import voltaic.api.gas.Gas;
import voltaic.registers.VoltaicRegistries;

public abstract class BaseLangKeyProvider
extends LanguageProvider {
    public final Locale locale;
    public final String modID;

    public BaseLangKeyProvider(PackOutput output, Locale locale, String modID) {
        super(output, modID, locale.toString());
        this.locale = locale;
        this.modID = modID;
    }

    public void addItem(RegistryObject<? extends Item> item, String translation) {
        this.add((Item)item.get(), translation);
    }

    public void addItem(Item item, String translation) {
        this.add(item, translation);
    }

    public void addBlock(RegistryObject<? extends Block> block, String translation) {
        this.add((Block)block.get(), translation);
    }

    public void addBlock(Block block, String translation) {
        this.add(block, translation);
    }

    public void addTooltip(String key, String translation) {
        this.add("tooltip." + this.modID + "." + key, translation);
    }

    public void addFluid(RegistryObject<? extends Fluid> fluid, String translation) {
        this.addFluid((Fluid)fluid.get(), translation);
    }

    public void addFluid(Fluid fluid, String translation) {
        this.add("fluid." + this.modID + "." + BuiltInRegistries.f_257020_.m_7981_((Object)fluid).m_135815_(), translation);
    }

    public void addGas(RegistryObject<Gas> gas, String translation) {
        this.addGas((Gas)gas.get(), translation);
    }

    public void addGas(Gas gas, String translation) {
        this.add("gas." + this.modID + "." + VoltaicRegistries.gasRegistry().getKey((Object)gas).m_135815_(), translation);
    }

    public void addContainer(String key, String translation) {
        this.add("container." + key, translation);
    }

    public void addCommand(String key, String translation) {
        this.add("command." + this.modID + "." + key, translation);
    }

    public void addSubtitle(String key, String translation) {
        this.add("subtitles." + this.modID + "." + key, translation);
    }

    public void addSubtitle(RegistryObject<SoundEvent> sound, String translation) {
        this.addSubtitle(sound.getId().m_135815_(), translation);
    }

    public void addGuiLabel(String key, String translation) {
        this.add("gui." + this.modID + "." + key, translation);
    }

    public void addDimension(ResourceKey<Level> dim, String translation) {
        this.addDimension(dim.m_135782_().m_135815_(), translation);
    }

    public void addDimension(String key, String translation) {
        this.add("dimension." + this.modID + "." + key, translation);
    }

    public void addKeyLabel(String key, String translation) {
        this.add("key." + this.modID + "." + key, translation);
    }

    public void addJei(String key, String translation) {
        this.add("jei." + key, translation);
    }

    public void addDamageSource(String key, String translation) {
        this.add("death.attack." + key, translation);
    }

    public void addChatMessage(String key, String translation) {
        this.add("chat." + this.modID + "." + key, translation);
    }

    public void addGuidebook(String key, String translation) {
        this.add("guidebook." + this.modID + "." + key, translation);
    }

    public void addAdvancement(String key, String translation) {
        this.add("advancement." + this.modID + "." + key, translation);
    }

    public void addCreativeTab(String key, String translation) {
        this.add("creativetab." + this.modID + "." + key, translation);
    }

    public static enum Locale {
        EN_US;


        public String toString() {
            return super.toString().toLowerCase(java.util.Locale.ROOT);
        }
    }
}

