/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.radiation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import voltaic.api.radiation.util.RadioactiveObject;

public abstract class BaseRadioactiveFluidsProvider
implements DataProvider {
    private final PackOutput output;
    private final String modID;
    private final String loc;

    public BaseRadioactiveFluidsProvider(PackOutput output, String modID) {
        this.output = output;
        this.modID = modID;
        this.loc = "data/voltaic/radiation/" + modID + "_radioactive_fluids";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        JsonObject json = new JsonObject();
        this.getRadioactiveFluids(json);
        Path parent = this.output.m_245114_().resolve(this.loc + ".json");
        return CompletableFuture.allOf(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)parent));
    }

    public abstract void getRadioactiveFluids(JsonObject var1);

    public void addFluid(Fluid fluid, double radiationAmount, double radiationStrength, JsonObject json) {
        JsonObject data = new JsonObject();
        json.add(BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString(), (JsonElement)RadioactiveObject.CODEC.encode((Object)new RadioactiveObject(radiationStrength, radiationAmount), (DynamicOps)JsonOps.INSTANCE, (Object)data).result().get());
    }

    public void addTag(TagKey<Fluid> tag, double radiationAmount, double radiationStrength, JsonObject json) {
        JsonObject data = new JsonObject();
        json.add("#" + tag.f_203868_().toString(), (JsonElement)RadioactiveObject.CODEC.encode((Object)new RadioactiveObject(radiationStrength, radiationAmount), (DynamicOps)JsonOps.INSTANCE, (Object)data).result().get());
    }

    public String m_6055_() {
        return this.modID + " Radioactive Fluids Provider";
    }
}

