/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class CustomShapedCraftingRecipe
extends ShapedRecipeBuilder.Result {
    @Nullable
    private ICondition[] recipeConditions;

    private CustomShapedCraftingRecipe(ResourceLocation recipeId, Item result, int count, List<String> pattern, Map<Character, Ingredient> keys, ICondition[] recipeConditions) {
        super(recipeId, result, count, "", CraftingBookCategory.MISC, pattern, keys, null, null, false);
        this.recipeConditions = recipeConditions;
    }

    public static Builder start(Item item, int count) {
        return new Builder(item, count);
    }

    public void m_7917_(JsonObject json) {
        super.m_7917_(json);
        if (this.recipeConditions == null || this.recipeConditions.length == 0) {
            return;
        }
        JsonArray conditions = new JsonArray();
        for (ICondition condition : this.recipeConditions) {
            conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        }
        json.add("conditions", (JsonElement)conditions);
    }

    public JsonObject m_5860_() {
        return null;
    }

    public static class Builder {
        private Item item;
        private int count;
        private List<String> patterns = new ArrayList<String>();
        private Map<Character, Ingredient> keys = new HashMap<Character, Ingredient>();
        @Nullable
        private ICondition[] recipeConditions;

        private Builder(Item item, int count) {
            this.item = item;
            this.count = count;
        }

        public Builder addPattern(String pattern) {
            if (pattern.length() > 3) {
                throw new UnsupportedOperationException("The pattern " + pattern + " is more than 3 characters long and is not valid!");
            }
            if (this.patterns.size() > 3) {
                throw new UnsupportedOperationException("Already 3 patterns present");
            }
            this.patterns.add(pattern);
            return this;
        }

        public Builder addKey(Character key, Ingredient ing) {
            this.keys.put(key, ing);
            return this;
        }

        public Builder addKey(Character key, TagKey<Item> ing) {
            this.keys.put(key, Ingredient.m_204132_(ing));
            return this;
        }

        public Builder addKey(Character key, String parent, String tag) {
            this.keys.put(key, Ingredient.m_204132_(Builder.itemTag(new ResourceLocation(parent, tag))));
            return this;
        }

        public Builder addKey(Character key, Item item) {
            return this.addKey(key, new ItemStack((ItemLike)item));
        }

        public Builder addKey(Character key, ItemStack item) {
            this.keys.put(key, Ingredient.m_43927_((ItemStack[])new ItemStack[]{item}));
            return this;
        }

        public Builder addConditions(ICondition ... conditions) {
            this.recipeConditions = conditions;
            return this;
        }

        public void complete(String parent, String name, Consumer<FinishedRecipe> consumer) {
            for (Character character : this.keys.keySet()) {
                if (!this.isKeyNotUsed(character.charValue())) continue;
                throw new UnsupportedOperationException("The key " + character + " is defined by never used!");
            }
            consumer.accept((FinishedRecipe)new CustomShapedCraftingRecipe(new ResourceLocation(parent, name), this.item, this.count, this.patterns, this.keys, this.recipeConditions));
        }

        private boolean isKeyNotUsed(char character) {
            for (String str : this.patterns) {
                for (char ch : str.toCharArray()) {
                    if (ch != character) continue;
                    return false;
                }
            }
            return true;
        }

        private static TagKey<Item> itemTag(ResourceLocation tag) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag);
        }
    }
}

