/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import voltaic.Voltaic;
import voltaic.prefab.properties.types.IPropertyType;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.tile.GenericTile;

public class PropertyManager {
    public static final String NBT_KEY = "propertydata";
    private final GenericTile owner;
    private ArrayList<AbstractProperty> properties = new ArrayList();
    private HashSet<AbstractProperty> dirtyPropertiesDirect = new HashSet();
    private boolean isDirty = false;

    public PropertyManager(GenericTile owner) {
        this.owner = owner;
    }

    public <T extends AbstractProperty> T addProperty(T prop) {
        this.properties.add(prop);
        prop.setManager(this);
        prop.setIndex(this.properties.size() - 1);
        return prop;
    }

    public ArrayList<AbstractProperty> getProperties() {
        return this.properties;
    }

    public void saveDirtyPropsToTag(CompoundTag tag) {
        for (AbstractProperty prop : this.dirtyPropertiesDirect) {
            prop.saveToTag(tag);
        }
    }

    public void saveAllPropsForClientSync(CompoundTag tag) {
        for (AbstractProperty prop : this.properties) {
            if (!prop.shouldUpdateClient()) continue;
            prop.saveToTag(tag);
        }
    }

    public void clean() {
        this.isDirty = false;
        for (AbstractProperty property : this.dirtyPropertiesDirect) {
            property.clean();
        }
        this.dirtyPropertiesDirect.clear();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(AbstractProperty dirtyProp) {
        this.isDirty = true;
        if (dirtyProp.shouldUpdateClient()) {
            this.dirtyPropertiesDirect.add(dirtyProp);
        }
    }

    public String toString() {
        Object string = "";
        for (int i = 0; i < this.properties.size(); ++i) {
            string = (String)string + i + ": " + this.properties.get(i).toString() + "\n";
        }
        return string;
    }

    public GenericTile getOwner() {
        return this.owner;
    }

    public void saveToTag(CompoundTag tag) {
        for (AbstractProperty prop : this.getProperties()) {
            if (!prop.shouldSave()) continue;
            prop.saveToTag(tag);
        }
    }

    public void loadFromTag(CompoundTag tag) {
        for (AbstractProperty prop : this.getProperties()) {
            if (!prop.shouldSave() || !tag.m_128441_(prop.getName())) continue;
            prop.loadFromTag(tag);
            tag.m_128473_(prop.getName());
        }
    }

    public void loadDataFromClient(int index, CompoundTag data) {
        if (index >= this.properties.size()) {
            Voltaic.LOGGER.error("The tile at " + this.owner.m_58899_() + " has a differently sized property list than what was declared by the packet");
            return;
        }
        AbstractProperty prop = this.properties.get(index);
        if (this.owner == null) {
            Voltaic.LOGGER.info("The property " + prop.getName() + " is sending data to a null tile");
            return;
        }
        if (this.owner.m_58904_() == null) {
            Voltaic.LOGGER.info("The property " + prop.getName() + " that sent data to the tile at " + this.owner.m_58899_() + " encountered a null level. The data was not loaded");
            return;
        }
        prop.setValue(prop.getType().readFromTag(new IPropertyType.TagReader(prop, data)));
    }

    public void onTileLoaded() {
        for (AbstractProperty property : this.properties) {
            property.onTileLoaded();
        }
    }
}

