/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.variant;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import voltaic.Voltaic;
import voltaic.prefab.properties.PropertyManager;
import voltaic.prefab.properties.types.IPropertyType;
import voltaic.prefab.properties.types.SetPropertyType;
import voltaic.prefab.properties.variant.AbstractProperty;

public class SetProperty<T>
extends AbstractProperty<HashSet<T>, SetPropertyType<T, ?>> {
    private boolean alreadySynced = false;
    private BiConsumer<SetProperty<T>, HashSet<T>> onChange = (prop, val) -> {};
    private Consumer<SetProperty<T>> onTileLoaded = prop -> {};

    public SetProperty(SetPropertyType<T, ?> type, String name, HashSet<T> defaultValue) {
        super(type, name, defaultValue);
    }

    @Override
    public void onTileLoaded() {
        this.onTileLoaded.accept(this);
    }

    @Override
    public void onLoadedFromTag(AbstractProperty<HashSet<T>, SetPropertyType<T, ?>> prop, HashSet<T> loadedValue) {
        this.onChange.accept((SetProperty)prop, loadedValue);
    }

    @Override
    public void setValue(Object updated) {
        if (this.alreadySynced) {
            return;
        }
        HashSet old = new HashSet((Collection)this.getValue());
        this.value = (HashSet)updated;
        this.setDirty();
        PropertyManager manager = this.getPropertyManager();
        if (this.isDirty() && manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept(this, old);
        }
    }

    public void addValue(Object updated) {
        if (this.alreadySynced || updated == null || ((HashSet)this.getValue()).contains(updated)) {
            return;
        }
        HashSet old = new HashSet((Collection)this.getValue());
        ((HashSet)this.getValue()).add(updated);
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept(this, old);
        }
    }

    public void addValues(Set<?> updated) {
        if (this.alreadySynced || updated == null) {
            return;
        }
        HashSet old = new HashSet((Collection)this.getValue());
        for (Object obj : updated) {
            ((HashSet)this.getValue()).add(obj);
        }
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept(this, old);
        }
    }

    public void removeValue(T value) {
        if (this.alreadySynced || !((HashSet)this.getValue()).contains(value)) {
            return;
        }
        HashSet old = new HashSet((Collection)this.getValue());
        ((HashSet)this.getValue()).remove(value);
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept(this, old);
        }
    }

    public void wipeSet() {
        PropertyManager manager = this.getPropertyManager();
        HashSet old = new HashSet((Collection)this.getValue());
        this.overwriteValue(new HashSet());
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept(this, old);
        }
    }

    public void copy(SetProperty<T> other) {
        HashSet otherVal = (HashSet)other.getValue();
        if (otherVal == null) {
            return;
        }
        this.overwriteValue(otherVal);
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        try {
            Object data = ((SetPropertyType)this.getType()).readFromTag(new IPropertyType.TagReader(this, tag));
            if (data != null) {
                this.value = data;
                this.onLoadedFromTag((AbstractProperty<HashSet<T>, SetPropertyType<T, ?>>)this, (HashSet)this.value);
            }
        }
        catch (Exception e) {
            Voltaic.LOGGER.info("Catching error while loading property " + this.getName() + " from NBT. Error: " + e.getMessage());
        }
    }
}

