/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.variant;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import voltaic.prefab.properties.PropertyManager;
import voltaic.prefab.properties.types.SinglePropertyType;
import voltaic.prefab.properties.variant.AbstractProperty;

public class SingleProperty<T>
extends AbstractProperty<T, SinglePropertyType<T, ?>> {
    private boolean alreadySynced = false;
    private BiConsumer<SingleProperty<T>, T> onChange = (prop, val) -> {};
    private Consumer<SingleProperty<T>> onTileLoaded = prop -> {};

    public SingleProperty(SinglePropertyType<T, ?> type, String name, T defaultValue) {
        super(type, name, defaultValue);
    }

    public SingleProperty<T> onChange(BiConsumer<SingleProperty<T>, T> event) {
        this.onChange = this.onChange.andThen(event);
        return this;
    }

    public SingleProperty<T> onTileLoaded(Consumer<SingleProperty<T>> event) {
        this.onTileLoaded = this.onTileLoaded.andThen(event);
        return this;
    }

    @Override
    public void setValue(Object updated) {
        if (this.alreadySynced) {
            return;
        }
        this.checkForChange(updated);
        Object old = this.getValue();
        this.value = updated;
        PropertyManager manager = this.getPropertyManager();
        if (this.isDirty() && manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept(this, (SingleProperty)old);
        }
    }

    public void copy(SingleProperty<T> other) {
        Object otherVal = other.getValue();
        if (otherVal == null) {
            return;
        }
        this.setValue(otherVal);
    }

    private boolean checkForChange(T updated) {
        boolean shouldUpdate;
        boolean bl = shouldUpdate = this.value == null && updated != null;
        if (this.value != null && updated != null) {
            boolean bl2 = shouldUpdate = !((SinglePropertyType)this.getType()).isEqual(this.value, updated);
        }
        if (shouldUpdate) {
            this.setDirty();
        }
        return shouldUpdate;
    }

    @Override
    public void onTileLoaded() {
        this.onTileLoaded.accept(this);
    }

    @Override
    public void onLoadedFromTag(AbstractProperty<T, SinglePropertyType<T, ?>> prop, T loadedValue) {
        this.onChange.accept((SingleProperty)prop, (SingleProperty)loadedValue);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }
}

