/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import voltaic.Voltaic;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.screen.ITexture;
import voltaic.api.screen.component.TextPropertySupplier;
import voltaic.prefab.screen.component.utils.AbstractScreenComponentInfo;

public class ScreenComponentCountdown
extends AbstractScreenComponentInfo {
    private final DoubleSupplier progressInfoHandler;
    private TextPropertySupplier tooltip;
    public static final ResourceLocation TEXTURE = Voltaic.rl("textures/screen/component/countdown.png");

    public ScreenComponentCountdown(TextPropertySupplier tooltip, DoubleSupplier progressInfoHandler, int x, int y) {
        super(CountdownTextures.BACKGROUND_DEFAULT, AbstractScreenComponentInfo.EMPTY, x, y);
        this.progressInfoHandler = progressInfoHandler;
        this.tooltip = tooltip;
    }

    public ScreenComponentCountdown(DoubleSupplier progressInfoHandler, int x, int y) {
        this(null, progressInfoHandler, x, y);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        int lengthBar = (int)(this.progressInfoHandler.getAsDouble() * (double)CountdownTextures.COUNTDOWN_BAR_DEFAULT.textureWidth());
        graphics.m_280163_(CountdownTextures.BACKGROUND_DEFAULT.getLocation(), guiWidth + this.xLocation + 1, guiHeight + this.yLocation + 1, (float)CountdownTextures.COUNTDOWN_BAR_DEFAULT.textureU(), (float)CountdownTextures.COUNTDOWN_BAR_DEFAULT.textureV(), lengthBar, CountdownTextures.COUNTDOWN_BAR_DEFAULT.textureHeight(), CountdownTextures.COUNTDOWN_BAR_DEFAULT.imageWidth(), CountdownTextures.COUNTDOWN_BAR_DEFAULT.imageHeight());
    }

    @Override
    protected List<? extends FormattedCharSequence> getInfo(List<? extends FormattedCharSequence> list) {
        if (this.tooltip != null) {
            return this.tooltip.getInfo();
        }
        return this.getTooltips();
    }

    private List<? extends FormattedCharSequence> getTooltips() {
        ArrayList<FormattedCharSequence> tips = new ArrayList<FormattedCharSequence>();
        if (this.progressInfoHandler != null) {
            tips.add(ChatFormatter.getChatDisplayShort(100.0 * this.progressInfoHandler.getAsDouble(), DisplayUnits.PERCENTAGE).m_130940_(ChatFormatting.GRAY).m_7532_());
        }
        return tips;
    }

    public static enum CountdownTextures implements ITexture
    {
        BACKGROUND_DEFAULT(60, 12, 0, 0, 256, 256, TEXTURE),
        COUNTDOWN_BAR_DEFAULT(58, 10, 0, 12, 256, 256, TEXTURE);

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private CountdownTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, ResourceLocation loc) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = loc;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

