/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.ScreenComponentGeneric;

public class ScreenComponentHorizontalSlider
extends ScreenComponentGeneric {
    private int sliderXOffset = 0;
    private boolean active = false;
    private boolean isHeld = false;
    private Consumer<Integer> sliderDragConsumer;
    private Consumer<Integer> sliderClickConsumer;

    public ScreenComponentHorizontalSlider(int x, int y, int width) {
        super(x, y, Math.max(width, 30), 14);
    }

    public ScreenComponentHorizontalSlider setDragConsumer(Consumer<Integer> responder) {
        this.sliderDragConsumer = responder;
        return this;
    }

    public ScreenComponentHorizontalSlider setClickConsumer(Consumer<Integer> responder) {
        this.sliderClickConsumer = responder;
        return this;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClick(button)) {
            this.onMouseDrag(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.isHeld = true;
        if (this.sliderDragConsumer != null) {
            this.sliderDragConsumer.accept((int)(mouseX - this.gui.getGuiWidth()));
        }
        super.onMouseDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isHeld && this.isPointInSlider(this.xLocation, this.yLocation, mouseX - this.gui.getGuiWidth(), mouseY - this.gui.getGuiHeight(), this.width, this.height) && this.sliderClickConsumer != null) {
            this.sliderClickConsumer.accept((int)(mouseX - this.gui.getGuiWidth()));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isHeld = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected boolean isPointInRegion(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)(x + this.sliderXOffset + 2) && xAxis <= (double)(x + 2 + this.sliderXOffset + 15) && yAxis >= (double)y && yAxis <= (double)(y + height - 1);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        HorizontalSliderTextures bg = HorizontalSliderTextures.SLIDER_BACKGROUND;
        graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation - 1, guiHeight + this.yLocation, 1, this.height, (float)bg.textureU(), (float)bg.textureV(), 1, bg.textureHeight(), bg.imageWidth(), bg.imageHeight());
        int permutations = (int)((double)(this.width - 2) / 28.0);
        int remainder = this.width - permutations * 28 - 2;
        for (int i = 0; i < permutations; ++i) {
            graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation + i * 28, guiHeight + this.yLocation, 28, this.height, (float)(bg.textureU() + 1), (float)bg.textureV(), 28, bg.textureHeight(), bg.imageWidth(), bg.imageHeight());
        }
        graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation + 28 * permutations, guiHeight + this.yLocation, remainder, this.height, (float)(bg.textureU() + 1), (float)bg.textureV(), remainder, bg.textureHeight(), bg.imageWidth(), bg.imageHeight());
        graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation + this.width - 2, guiHeight + this.yLocation, 1, this.height, (float)(bg.textureU() + 29), (float)bg.textureV(), 1, bg.textureHeight(), bg.imageWidth(), bg.imageHeight());
        HorizontalSliderTextures slider = this.active ? HorizontalSliderTextures.SLIDER_ACTIVE : HorizontalSliderTextures.SLIDER_INACTIVE;
        graphics.m_280411_(slider.getLocation(), guiWidth + this.xLocation + this.sliderXOffset, guiHeight + this.yLocation + 1, slider.textureWidth(), slider.textureHeight(), (float)slider.textureU(), (float)slider.textureV(), slider.textureWidth(), slider.textureHeight(), slider.imageWidth(), slider.imageHeight());
    }

    public void updateActive(boolean active) {
        this.active = active;
    }

    public void setSliderXOffset(int offset) {
        this.sliderXOffset = Math.min(offset, this.width - 2 - 15);
    }

    protected boolean isPointInSlider(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)x && xAxis <= (double)(x + width - 1) && yAxis >= (double)y && yAxis <= (double)(y + height - 1);
    }

    public boolean isSliderActive() {
        return this.active;
    }

    public boolean isSliderHeld() {
        return this.isHeld;
    }

    public static enum HorizontalSliderTextures implements ITexture
    {
        SLIDER_BACKGROUND(30, 14, 0, 0, 30, 14, Voltaic.rl("textures/screen/component/horizontalslider/horizontal_slider_bg.png")),
        SLIDER_ACTIVE(15, 12, 0, 0, 15, 12, Voltaic.rl("textures/screen/component/horizontalslider/horizontal_slider_active.png")),
        SLIDER_INACTIVE(15, 12, 0, 0, 15, 12, Voltaic.rl("textures/screen/component/horizontalslider/horizontal_slider_inactive.png"));

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private HorizontalSliderTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, ResourceLocation loc) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = loc;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

