/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.guitab;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.util.FormattedCharSequence;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.gas.PropertyGasTank;
import voltaic.api.screen.component.TextPropertySupplier;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponentInfo;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentGasHandler;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ScreenComponentGasPressure
extends ScreenComponentGuiTab {
    public ScreenComponentGasPressure(TextPropertySupplier infoHandler, int x, int y) {
        super(ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, ScreenComponentSlot.IconType.PRESSURE_GAUGE, infoHandler, x, y);
    }

    public ScreenComponentGasPressure(int x, int y) {
        super(ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, ScreenComponentSlot.IconType.PRESSURE_GAUGE, AbstractScreenComponentInfo.EMPTY, x, y);
    }

    @Override
    protected List<? extends FormattedCharSequence> getInfo(List<? extends FormattedCharSequence> list) {
        if (this.infoHandler == EMPTY) {
            return this.getMaxPressureInfo();
        }
        return super.getInfo(list);
    }

    private List<? extends FormattedCharSequence> getMaxPressureInfo() {
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        GenericTile generic = (GenericTile)((GenericContainerBlockEntity)((GenericScreen)this.gui).m_6262_()).getSafeHost();
        if (generic == null) {
            return tooltips;
        }
        IComponentGasHandler handler = (IComponentGasHandler)generic.getComponent(IComponentType.GasHandler);
        int index = 1;
        for (PropertyGasTank tank : handler.getInputTanks()) {
            tooltips.add(VoltaicTextUtils.tooltip("tankmaxin", index, ChatFormatter.getChatDisplayShort(tank.getMaxPressure(), DisplayUnits.PRESSURE_ATM)).m_130940_(ChatFormatting.GRAY).m_7532_());
            ++index;
        }
        index = 1;
        for (PropertyGasTank tank : handler.getOutputTanks()) {
            tooltips.add(VoltaicTextUtils.tooltip("tankmaxout", index, ChatFormatter.getChatDisplayShort(tank.getMaxPressure(), DisplayUnits.PRESSURE_ATM)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            ++index;
        }
        return tooltips;
    }
}

